/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.yoyos.common;

import com.jozufozu.yoyos.Yoyos;
import com.jozufozu.yoyos.common.EntityYoyo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityStickyYoyo
extends EntityYoyo {
    private static final DataParameter<Byte> REEL_DIRECTION = EntityDataManager.func_187226_a(EntityStickyYoyo.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Boolean> STUCK = EntityDataManager.func_187226_a(EntityStickyYoyo.class, (DataSerializer)DataSerializers.field_187198_h);
    private int stuckSince;

    public EntityStickyYoyo(World world) {
        super(world);
    }

    public EntityStickyYoyo(World world, EntityPlayer player, EnumHand hand) {
        super(world, player, hand);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(REEL_DIRECTION, (Object)0);
        this.func_184212_Q().func_187214_a(STUCK, (Object)false);
    }

    public int getReelDirection() {
        return ((Byte)this.func_184212_Q().func_187225_a(REEL_DIRECTION)).byteValue();
    }

    public void setReelDirection(byte reelDirection) {
        this.func_184212_Q().func_187227_b(REEL_DIRECTION, (Object)reelDirection);
        this.func_184212_Q().func_187217_b(REEL_DIRECTION);
    }

    public boolean isStuck() {
        return (Boolean)this.func_184212_Q().func_187225_a(STUCK);
    }

    public void setStuck(boolean stuck) {
        this.func_184212_Q().func_187227_b(STUCK, (Object)stuck);
        this.func_184212_Q().func_187217_b(STUCK);
    }

    public void changeLength(float amount) {
        this.setCurrentLength(Math.min(this.getCurrentLength() + amount, this.getMaxLength()));
    }

    @Override
    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.func_184202_aL());
        }
        this.func_70030_z();
        if (this.thrower != null && !this.thrower.field_70128_L) {
            this.yoyo = this.checkAndGetYoyoObject();
            if (this.yoyo == null) {
                return;
            }
            double dx = this.thrower.field_70165_t - this.field_70165_t;
            double dy = this.thrower.field_70163_u + (double)this.thrower.eyeHeight - (this.field_70163_u + (double)this.field_70131_O * 0.5);
            double dz = this.thrower.field_70161_v - this.field_70161_v;
            double distanceSqr = dx * dx + dy * dy + dz * dz;
            if (this.getReelDirection() < 0 && (double)this.getCurrentLength() > 0.1 && distanceSqr < (double)(this.getCurrentLength() * this.getCurrentLength() + 8.0f)) {
                this.changeLength(-0.5f);
            }
            if (this.getReelDirection() > 0 && this.getCurrentLength() < this.getMaxLength()) {
                if (distanceSqr < (double)(this.getCurrentLength() * this.getCurrentLength() + 2.0f)) {
                    this.changeLength(0.1f);
                } else {
                    this.setCurrentLength(MathHelper.func_76133_a((double)distanceSqr));
                }
            }
            if (!this.isRetracting() && !this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ().func_186662_g(0.1)).isEmpty()) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
                if (!this.isStuck()) {
                    this.stuckSince = this.field_70173_aa;
                    this.setCurrentLength(MathHelper.func_76133_a((double)distanceSqr));
                    this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, Yoyos.YOYO_STICK, SoundCategory.PLAYERS, 0.7f, 3.0f);
                    this.yoyo.damageItem(this.getYoyoStack(), 1, (EntityLivingBase)this.thrower);
                }
                this.setStuck(true);
                this.handlePlayerPulling();
            } else {
                if (this.isRetracting() && this.isStuck()) {
                    this.func_70106_y();
                }
                if (this.decrementRemainingTime() == 0) {
                    this.forceRetract();
                }
                this.updateMotion();
                this.moveAndCollide();
                if (!this.field_70170_p.field_72995_K && this.doesBlockInteraction()) {
                    this.worldInteraction();
                }
                this.setStuck(false);
            }
            if (this.isCollecting()) {
                this.updateCapturedDrops();
            }
            this.resetOrIncrementAttackCooldown();
        } else {
            this.func_70106_y();
        }
    }

    @Override
    public float getRotation(int age, float partialTicks) {
        return this.isStuck() ? super.getRotation(this.stuckSince, 0.0f) : super.getRotation(age - this.stuckSince, partialTicks);
    }
}

