/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.world;

import com.bafomdad.uniquecrops.init.UCBlocks;
import com.bafomdad.uniquecrops.init.UCDimension;
import com.bafomdad.uniquecrops.init.UCLootTables;
import com.bafomdad.uniquecrops.world.RuinedBricksProcessor;
import com.bafomdad.uniquecrops.world.WorldGenSkyTree;
import java.util.Map;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.common.IWorldGenerator;

public class CropIslandGenerator
implements IWorldGenerator {
    public static final ResourceLocation PLATFORM = new ResourceLocation("uniquecrops", "platform0");
    public static final ResourceLocation ISLAND_TOP = new ResourceLocation("uniquecrops", "islandtop0");
    public static final ResourceLocation ISLAND_BOTTOM = new ResourceLocation("uniquecrops", "islandbottom0");
    private static final ResourceLocation[] LOOTS = new ResourceLocation[]{UCLootTables.CHEST_ISLAND, LootTableList.field_191192_o};

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkGenerator chunk, IChunkProvider provider) {
        if (!this.canGenerate(world.field_73011_w.getDimension())) {
            return;
        }
        if (!(world instanceof WorldServer)) {
            return;
        }
        if (this.shouldFillChunk(chunkX, chunkZ, 4)) {
            int x = chunkX * 16 + 1;
            int z = chunkZ * 16 + 1;
            int y = 20;
            MinecraftServer server = ((WorldServer)world).func_73046_m();
            Rotation rotation = Rotation.values()[rand.nextInt(Rotation.values().length)];
            PlacementSettings settings = new PlacementSettings().func_186220_a(rotation);
            BlockPos blockPos = new BlockPos(x, y, z);
            Template islandBottom = ((WorldServer)world).func_184163_y().func_186237_a(server, ISLAND_BOTTOM);
            BlockPos transformedPos = islandBottom.func_189961_a(blockPos, Mirror.NONE, rotation);
            islandBottom.func_186253_b(world, transformedPos, settings);
            Template islandTop = ((WorldServer)world).func_184163_y().func_186237_a(server, ISLAND_TOP);
            BlockPos posTop = blockPos.func_177981_b(islandBottom.func_186259_a().func_177956_o());
            transformedPos = islandTop.func_189961_a(posTop, Mirror.NONE, rotation);
            WorldGenSkyTree tree = new WorldGenSkyTree(true, rand.nextBoolean());
            islandTop.func_186253_b(world, transformedPos, settings);
            Map mapData = islandTop.func_186258_a(transformedPos, settings);
            for (Map.Entry entry : mapData.entrySet()) {
                BlockPos keyPos;
                BlockPos chestPos;
                TileEntity tile;
                String data = (String)entry.getValue();
                if ("islandchest".equals(data) && (tile = world.func_175625_s((chestPos = (BlockPos)entry.getKey()).func_177977_b())) instanceof TileEntityLockableLoot) {
                    ((TileEntityLockableLoot)tile).func_189404_a(LOOTS[rand.nextInt(LOOTS.length)], rand.nextLong());
                }
                if ("tree0".equals(data)) {
                    keyPos = (BlockPos)entry.getKey();
                    if (rand.nextInt(5) == 0) {
                        this.generateTree(world, rand, keyPos);
                    }
                }
                if (!"tree1".equals(data)) continue;
                keyPos = (BlockPos)entry.getKey();
                if (rand.nextInt(4) == 0) {
                    this.generateTree(world, rand, keyPos);
                    continue;
                }
                if (rand.nextBoolean()) {
                    world.func_175698_g(keyPos);
                    world.func_180501_a(keyPos.func_177977_b(), Blocks.field_150355_j.func_176223_P(), 2);
                    world.func_180501_a(keyPos, Blocks.field_150392_bi.func_176223_P(), 2);
                    continue;
                }
                world.func_180501_a(keyPos.func_177977_b(), UCBlocks.oldGrass.func_176223_P(), 2);
            }
        } else {
            this.generatePlatform(rand, chunkX, chunkZ, (WorldServer)world);
        }
    }

    private void generatePlatform(Random rand, int chunkX, int chunkZ, WorldServer worldServer) {
        int x = chunkX * 16 + 1;
        int z = chunkZ * 16 + 1;
        int y = 36 + rand.nextInt(1);
        MinecraftServer server = worldServer.func_73046_m();
        Rotation rotation = Rotation.values()[rand.nextInt(Rotation.values().length)];
        PlacementSettings settings = new PlacementSettings().func_186220_a(rotation);
        BlockPos pos = new BlockPos(x, y, z);
        Template platform = worldServer.func_184163_y().func_186237_a(server, PLATFORM);
        BlockPos transformedPos = platform.func_189961_a(pos, Mirror.NONE, rotation);
        RuinedBricksProcessor customProcessor = new RuinedBricksProcessor(transformedPos, settings);
        platform.func_189960_a((World)worldServer, transformedPos, (ITemplateProcessor)customProcessor, settings, 2);
    }

    private void generateTree(World world, Random rand, BlockPos pos) {
        world.func_175698_g(pos);
        WorldGenSkyTree treeGen = new WorldGenSkyTree(true, rand.nextBoolean());
        treeGen.func_180709_b(world, rand, pos);
    }

    private boolean shouldFillChunk(int x, int z, int spacing) {
        int xOffset = x;
        int zOffset = z;
        int clusterSize = 1;
        int width = spacing + clusterSize;
        if (xOffset < 0) {
            xOffset = -xOffset + clusterSize;
        }
        if (zOffset < 0) {
            zOffset = -zOffset + clusterSize;
        }
        return (xOffset %= width) < clusterSize && (zOffset %= width) < clusterSize;
    }

    private boolean canGenerate(int dim) {
        return dim == UCDimension.dimID;
    }
}

