/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.network;

import com.bafomdad.uniquecrops.UniqueCrops;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketUCEffect
implements IMessage {
    EnumParticleTypes type;
    private double x;
    private double y;
    private double z;
    private int loopSize;

    public PacketUCEffect() {
    }

    public PacketUCEffect(EnumParticleTypes type, double x, double y, double z, int loopSize) {
        this.type = type;
        this.x = x;
        this.y = y;
        this.z = z;
        this.loopSize = loopSize;
    }

    public void fromBytes(ByteBuf buf) {
        this.type = EnumParticleTypes.values()[buf.readShort()];
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.loopSize = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeShort(this.type.ordinal());
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeInt(this.loopSize);
    }

    public static class Handler
    implements IMessageHandler<PacketUCEffect, IMessage> {
        public IMessage onMessage(PacketUCEffect message, MessageContext ctx) {
            UniqueCrops.proxy.spawnParticles(message.type, message.x, message.y, message.z, message.loopSize);
            return null;
        }
    }
}

