/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.items.baubles;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.IBauble;
import com.bafomdad.uniquecrops.UniqueCrops;
import com.bafomdad.uniquecrops.core.NBTUtils;
import com.bafomdad.uniquecrops.core.enums.EnumEmblems;
import com.bafomdad.uniquecrops.init.UCItems;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="baubles.api.IBauble", modid="baubles", striprefs=true)
public abstract class ItemBauble
extends Item
implements IBauble {
    private static final String HASHCODE = "playerHashcode";
    private static final String UUID_MOST = "attributeUUIDMost";
    private static final String UUID_LEAST = "attributeUUIDLeast";
    final Multimap<String, AttributeModifier> attributes = HashMultimap.create();
    private EnumEmblems type;

    public ItemBauble(EnumEmblems type) {
        this.type = type;
        this.setRegistryName("emblem." + type.toString().toLowerCase());
        this.func_77655_b("uniquecrops.emblem" + type.toString().toLowerCase());
        this.func_77637_a(UniqueCrops.TAB);
        this.func_77625_d(1);
        UCItems.items.add(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World player, List<String> list, ITooltipFlag advanced) {
        if (this.getDescription() != null && !this.getDescription().isEmpty()) {
            list.add(I18n.func_135052_a((String)("uniquecrops.tooltip." + this.getDescription()), (Object[])new Object[0]));
        }
    }

    public abstract String getDescription();

    public BaubleType getBaubleType(ItemStack stack) {
        return BaubleType.CHARM;
    }

    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        if (this.getLastPlayerHashcode(stack) != player.hashCode()) {
            this.onEquippedOrLoadedIntoWorld(stack, player);
            this.setLastPlayerHashcode(stack, player.hashCode());
        }
    }

    public void onEquipped(ItemStack stack, EntityLivingBase player) {
        if (player != null) {
            this.onEquippedOrLoadedIntoWorld(stack, player);
            this.setLastPlayerHashcode(stack, player.hashCode());
        }
    }

    public void onUnequipped(ItemStack stack, EntityLivingBase player) {
    }

    public boolean canEquip(ItemStack stack, EntityLivingBase player) {
        return true;
    }

    public boolean canUnequip(ItemStack stack, EntityLivingBase player) {
        return true;
    }

    public boolean willAutoSync(ItemStack itemstack, EntityLivingBase player) {
        return false;
    }

    abstract void fillModifiers(Multimap<String, AttributeModifier> var1, ItemStack var2);

    public void onEquippedOrLoadedIntoWorld(ItemStack stack, EntityLivingBase player) {
    }

    public UUID getBaubleUUID(ItemStack stack) {
        long most = NBTUtils.getLong(stack, UUID_MOST, 0L);
        if (most == 0L) {
            UUID uuid = UUID.randomUUID();
            NBTUtils.setLong(stack, UUID_MOST, uuid.getMostSignificantBits());
            NBTUtils.setLong(stack, UUID_LEAST, uuid.getLeastSignificantBits());
            return this.getBaubleUUID(stack);
        }
        long least = NBTUtils.getLong(stack, UUID_LEAST, 0L);
        return new UUID(most, least);
    }

    public int getLastPlayerHashcode(ItemStack stack) {
        return NBTUtils.getInt(stack, HASHCODE, 0);
    }

    public void setLastPlayerHashcode(ItemStack stack, int hash) {
        NBTUtils.setInt(stack, HASHCODE, hash);
    }

    protected boolean hasBauble(EntityPlayer player) {
        ItemStack bauble = BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(BaubleType.CHARM.ordinal());
        return !bauble.func_190926_b() && bauble.func_77973_b() == this;
    }
}

