/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.items;

import com.bafomdad.uniquecrops.UniqueCrops;
import com.bafomdad.uniquecrops.core.enums.EnumItems;
import com.bafomdad.uniquecrops.init.UCBlocks;
import com.bafomdad.uniquecrops.init.UCItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemEnderSnooker
extends Item {
    private static final int MAX_DISTANCE = 256;

    public ItemEnderSnooker() {
        this.setRegistryName("endersnooker");
        this.func_77655_b("uniquecrops.endersnooker");
        this.func_77637_a(UniqueCrops.TAB);
        this.func_77656_e(16);
        this.func_77625_d(1);
        UCItems.items.add(this);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState state;
        if (player.func_70093_af() && (state = world.func_180495_p(pos)).func_177230_c() == UCBlocks.darkBlock) {
            if (!world.field_72995_K) {
                if (pos.func_177956_o() <= 1) {
                    world.func_180501_a(pos, Blocks.field_150357_h.func_176223_P(), 2);
                }
                world.func_175698_g(pos);
            }
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)new ItemStack(UCBlocks.darkBlock));
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && stack.func_77973_b() == this) {
            List<EntityLivingBase> elb = this.acquireAllLookTargets((EntityLivingBase)player, 32, 3.0);
            for (EntityLivingBase target : elb) {
                if (!target.func_70685_l((Entity)player) || target instanceof EntityPlayer || !target.func_184222_aU()) continue;
                BlockPos targetpos = target.func_180425_c();
                BlockPos playerpos = player.func_180425_c();
                if (world.field_72995_K) continue;
                target.func_70634_a((double)playerpos.func_177958_n(), (double)playerpos.func_177956_o(), (double)playerpos.func_177952_p());
                player.func_70634_a((double)targetpos.func_177958_n(), (double)targetpos.func_177956_o(), (double)targetpos.func_177952_p());
                if (target instanceof EntityWolf && world.field_73012_v.nextInt(100) == 0) {
                    target.func_70099_a(EnumItems.DOGRESIDUE.createStack(), 1.0f);
                }
                stack.func_77972_a(1, (EntityLivingBase)player);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    private List<EntityLivingBase> acquireAllLookTargets(EntityLivingBase seeker, int distance, double radius) {
        if (distance < 0 || distance > 256) {
            distance = 256;
        }
        ArrayList<EntityLivingBase> targets = new ArrayList<EntityLivingBase>();
        Vec3d vec3 = seeker.func_70040_Z();
        double targetX = seeker.field_70165_t;
        double targetY = seeker.field_70163_u + (double)seeker.func_70047_e() - (double)0.1f;
        double targetZ = seeker.field_70161_v;
        double distanceTraveled = 0.0;
        while ((int)distanceTraveled < distance) {
            distanceTraveled += vec3.func_72433_c();
            AxisAlignedBB bb = new AxisAlignedBB((targetX += vec3.field_72450_a) - radius, (targetY += vec3.field_72448_b) - radius, (targetZ += vec3.field_72449_c) - radius, targetX + radius, targetY + radius, targetZ + radius);
            List list = seeker.field_70170_p.func_72872_a(EntityLivingBase.class, bb);
            for (EntityLivingBase target : list) {
                if (target == seeker || !target.func_70067_L() || !this.isTargetInSight(vec3, seeker, (Entity)target) || targets.contains(target)) continue;
                targets.add(target);
            }
        }
        return targets;
    }

    private boolean isTargetInSight(Vec3d vec3, EntityLivingBase seeker, Entity target) {
        return seeker.func_70685_l(target) && this.isTargetInFrontOf((Entity)seeker, target, 60.0f);
    }

    private boolean isTargetInFrontOf(Entity seeker, Entity target, float fov) {
        double dx = target.field_70165_t - seeker.field_70165_t;
        double dz = target.field_70161_v - seeker.field_70161_v;
        while (dx * dx + dz * dz < 1.0E-4) {
            dx = (Math.random() - Math.random()) * 0.01;
            dz = (Math.random() - Math.random()) * 0.01;
        }
        while (seeker.field_70177_z > 360.0f) {
            seeker.field_70177_z -= 360.0f;
        }
        while (seeker.field_70177_z < -360.0f) {
            seeker.field_70177_z += 360.0f;
        }
        float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - seeker.field_70177_z;
        yaw -= 90.0f;
        while (yaw < -180.0f) {
            yaw += 360.0f;
        }
        while (yaw >= 180.0f) {
            yaw -= 360.0f;
        }
        return yaw < fov && yaw > -fov;
    }
}

