/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.items;

import com.bafomdad.uniquecrops.UniqueCrops;
import com.bafomdad.uniquecrops.api.IBookUpgradeable;
import com.bafomdad.uniquecrops.core.NBTUtils;
import com.bafomdad.uniquecrops.init.UCItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBootsLeague
extends ItemArmor
implements IBookUpgradeable {
    private static final float DEFAULT_SPEED = 0.055f;
    private static final float JUMPFACTOR = 0.2f;
    private static final float FALLBUFFER = 2.0f;
    private static final List<String> CMONSTEPITUP = new ArrayList<String>();

    public ItemBootsLeague(ItemArmor.ArmorMaterial material, int renderindex, EntityEquipmentSlot slot) {
        super(material, renderindex, slot);
        this.setRegistryName("bootsleague");
        this.func_77655_b("uniquecrops.bootsleague");
        this.func_77637_a(UniqueCrops.TAB);
        this.func_77656_e(200);
        UCItems.items.add((Item)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World player, List<String> list, ITooltipFlag whatisthis) {
        list.add(I18n.func_135052_a((String)"uniquecrops.tooltip.bootsleague", (Object[])new Object[0]));
        int upgradeLevel = this.getLevel(stack);
        if (upgradeLevel > -1) {
            list.add(TextFormatting.GOLD + "+" + upgradeLevel);
        } else {
            list.add(TextFormatting.GOLD + "Upgradeable");
        }
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        String name = this.getPlayerStr(player);
        if (CMONSTEPITUP.contains(name)) {
            if (world.field_72995_K) {
                float SPEED = NBTUtils.getFloat(stack, "UC:speedModifier", 0.055f);
                if ((player.field_70122_E || player.field_71075_bZ.field_75100_b) && player.field_191988_bg > 0.0f && !player.func_70055_a(Material.field_151586_h)) {
                    player.func_191958_b(0.0f, 0.0f, 1.0f, player.field_71075_bZ.field_75100_b ? SPEED : SPEED);
                }
                player.field_70138_W = player.func_70093_af() ? 0.60001f : 1.0625f;
                this.snapForward(player, stack);
            }
        } else {
            CMONSTEPITUP.add(name);
            player.field_70138_W = 1.0625f;
        }
    }

    private void snapForward(EntityPlayer player, ItemStack stack) {
        float speedMod = 0.95f;
        int sprintTicks = NBTUtils.getInt(stack, "UC:sprintingTicks", 0);
        if (sprintTicks > 0) {
            NBTUtils.setInt(stack, "UC:sprintingTicks", sprintTicks - 1);
            return;
        }
        if (player.func_70051_ag() && !player.field_71075_bZ.field_75100_b) {
            if (NBTUtils.getFloat(stack, "UC:speedModifier", 0.055f) == 0.055f) {
                NBTUtils.setFloat(stack, "UC:speedModifier", speedMod * (float)Math.max(this.getLevel(stack), 1));
                return;
            }
            player.func_70031_b(false);
            NBTUtils.setInt(stack, "UC:sprintingTicks", 20);
        }
        if (!player.func_70051_ag()) {
            NBTUtils.setFloat(stack, "UC:speedModifier", 0.055f);
        }
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    @SubscribeEvent
    public void playerTick(LivingEvent.LivingUpdateEvent event) {
        ItemStack boots;
        EntityPlayer player;
        String name;
        if (event.getEntityLiving() instanceof EntityPlayer && CMONSTEPITUP.contains(name = this.getPlayerStr(player = (EntityPlayer)event.getEntityLiving())) && ((boots = player.func_184582_a(EntityEquipmentSlot.FEET)).func_190926_b() || boots.func_77973_b() != UCItems.bootsLeague)) {
            player.field_70138_W = 0.6f;
            CMONSTEPITUP.remove(name);
        }
    }

    @SubscribeEvent
    public void onPlayerJump(LivingEvent.LivingJumpEvent event) {
        EntityPlayer player;
        ItemStack boots;
        if (event.getEntityLiving() instanceof EntityPlayer && !(boots = (player = (EntityPlayer)event.getEntityLiving()).func_184582_a(EntityEquipmentSlot.FEET)).func_190926_b() && boots.func_77973_b() == UCItems.bootsLeague) {
            player.field_70181_x += (double)0.2f;
            player.field_70143_R = -2.0f;
        }
    }

    @SubscribeEvent
    public void playerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        String username = event.player.func_146103_bH().getName();
        CMONSTEPITUP.remove(username + ":false");
        CMONSTEPITUP.remove(username + ":true");
    }

    private String getPlayerStr(EntityPlayer player) {
        return player.func_146103_bH().getName() + ":" + player.field_70170_p.field_72995_K;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }
}

