/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.items;

import com.bafomdad.uniquecrops.UniqueCrops;
import com.bafomdad.uniquecrops.core.NBTUtils;
import com.bafomdad.uniquecrops.core.UCConfig;
import com.bafomdad.uniquecrops.core.UCEnergyStorage;
import com.bafomdad.uniquecrops.init.UCItems;
import java.text.NumberFormat;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBeanBattery
extends Item {
    public ItemBeanBattery() {
        this.setRegistryName("beanpower");
        this.func_77655_b("uniquecrops.beanpower");
        this.func_77637_a(UniqueCrops.TAB);
        this.func_77625_d(1);
        UCItems.items.add(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        IEnergyStorage storage;
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null) && (storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)) != null) {
            NumberFormat format = NumberFormat.getInstance();
            tooltip.add(String.format("%s/%s Bean Power", format.format(storage.getEnergyStored()), format.format(storage.getMaxEnergyStored())));
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        IEnergyStorage storage;
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null) && (storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)) != null) {
            double max = storage.getMaxEnergyStored();
            double diff = max - (double)storage.getEnergyStored();
            return diff / max;
        }
        return super.getDurabilityForDisplay(stack);
    }

    public void setEnergy(ItemStack stack, int energy) {
        IEnergyStorage storage;
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null) && (storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)) instanceof UCEnergyStorage) {
            UCEnergyStorage es = (UCEnergyStorage)storage;
            es.setEnergyStored(Math.min(energy, es.getMaxEnergyStored()));
        }
    }

    public int receiveEnergy(ItemStack stack, int maxReceive, boolean simulate) {
        IEnergyStorage storage;
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null) && (storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)) != null) {
            return storage.receiveEnergy(maxReceive, simulate);
        }
        return 0;
    }

    public int extractEnergy(ItemStack stack, int maxExtract, boolean simulate) {
        IEnergyStorage storage;
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null) && (storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)) != null) {
            return storage.extractEnergy(maxExtract, simulate);
        }
        return 0;
    }

    public int getEnergyStored(ItemStack stack) {
        IEnergyStorage storage;
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null) && (storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)) != null) {
            return storage.getEnergyStored();
        }
        return 0;
    }

    public int getMaxEnergyStored(ItemStack stack) {
        IEnergyStorage storage;
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null) && (storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)) != null) {
            return storage.getMaxEnergyStored();
        }
        return 0;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound tag) {
        if (stack.func_77973_b() == this) {
            return new EnergyItemProvider(stack, this);
        }
        return null;
    }

    private static class EnergyItemProvider
    implements ICapabilityProvider {
        public final UCEnergyStorage storage;

        public EnergyItemProvider(final ItemStack stack, ItemBeanBattery item) {
            this.storage = new UCEnergyStorage(UCConfig.beanBatteryCapacity, 200){

                public int getEnergyStored() {
                    if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Energy")) {
                        return NBTUtils.getInt(stack, "Energy", 0);
                    }
                    return 0;
                }

                @Override
                public void setEnergyStored(int energy) {
                    if (!stack.func_77942_o()) {
                        stack.func_77982_d(new NBTTagCompound());
                    }
                    stack.func_77978_p().func_74768_a("Energy", energy);
                }
            };
        }

        public boolean hasCapability(Capability<?> cap, EnumFacing facing) {
            return this.getCapability(cap, facing) != null;
        }

        public <T> T getCapability(Capability<T> cap, EnumFacing facing) {
            if (cap == CapabilityEnergy.ENERGY) {
                return (T)((Object)this.storage);
            }
            return null;
        }
    }
}

