/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.integration.jei;

import com.bafomdad.uniquecrops.UniqueCropsAPI;
import com.bafomdad.uniquecrops.core.enums.EnumItems;
import com.bafomdad.uniquecrops.crafting.EnchantmentRecipe;
import com.bafomdad.uniquecrops.crafting.HeaterRecipe;
import com.bafomdad.uniquecrops.crafting.HourglassRecipe;
import com.bafomdad.uniquecrops.crafting.SeedRecipe;
import com.bafomdad.uniquecrops.init.UCBlocks;
import com.bafomdad.uniquecrops.init.UCItems;
import com.bafomdad.uniquecrops.integration.jei.UCEnchanterCategory;
import com.bafomdad.uniquecrops.integration.jei.UCEnchanterWrapper;
import com.bafomdad.uniquecrops.integration.jei.UCHeaterCategory;
import com.bafomdad.uniquecrops.integration.jei.UCHeaterWrapper;
import com.bafomdad.uniquecrops.integration.jei.UCHourglassCategory;
import com.bafomdad.uniquecrops.integration.jei.UCHourglassWrapper;
import com.bafomdad.uniquecrops.integration.jei.UCRecipeCategory;
import com.bafomdad.uniquecrops.integration.jei.UCRecipeWrapper;
import java.util.ArrayList;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IIngredientBlacklist;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@JEIPlugin
public class JEIPluginUC
implements IModPlugin {
    public static final String UID_SEED_RECIPE = "jei.uniquecrops.seedrecipe";
    public static final String UUID_HOURGLASS_RECIPE = "jei.uniquecrops.hourglassrecipe";
    public static final String UUID_HEATER_RECIPE = "jei.uniquecrops.heaterrecipe";
    public static final String UUID_ENCHANTER_RECIPE = "jei.uniquecrops.enchanterrecipe";

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new UCRecipeCategory(guiHelper, UID_SEED_RECIPE)});
        registry.addRecipeCategories(new IRecipeCategory[]{new UCHourglassCategory(guiHelper, UUID_HOURGLASS_RECIPE)});
        registry.addRecipeCategories(new IRecipeCategory[]{new UCHeaterCategory(guiHelper, UUID_HEATER_RECIPE)});
        registry.addRecipeCategories(new IRecipeCategory[]{new UCEnchanterCategory(guiHelper, UUID_ENCHANTER_RECIPE)});
    }

    public void register(IModRegistry registry) {
        registry.handleRecipes(SeedRecipe.class, UCRecipeWrapper::new, UID_SEED_RECIPE);
        registry.handleRecipes(HourglassRecipe.class, UCHourglassWrapper::new, UUID_HOURGLASS_RECIPE);
        registry.handleRecipes(HeaterRecipe.class, UCHeaterWrapper::new, UUID_HEATER_RECIPE);
        registry.handleRecipes(EnchantmentRecipe.class, UCEnchanterWrapper::new, UUID_ENCHANTER_RECIPE);
        registry.addRecipes(UniqueCropsAPI.SEED_RECIPE_REGISTRY.getRecipeList(new ArrayList<SeedRecipe>()), UID_SEED_RECIPE);
        registry.addRecipes(UniqueCropsAPI.HOURGLASS_RECIPE_REGISTRY.getRecipeList(new ArrayList<HourglassRecipe>()), UUID_HOURGLASS_RECIPE);
        registry.addRecipes(UniqueCropsAPI.MASSHEATER_REGISTRY.getRecipeList(new ArrayList<HeaterRecipe>()), UUID_HEATER_RECIPE);
        registry.addRecipes(UniqueCropsAPI.ENCHANTER_REGISTRY.getRecipeList(new ArrayList<EnchantmentRecipe>()), UUID_ENCHANTER_RECIPE);
        registry.addRecipeCatalyst((Object)EnumItems.DUMMYITEM.createStack(), new String[]{UID_SEED_RECIPE});
        registry.addRecipeCatalyst((Object)new ItemStack(UCBlocks.hourglass), new String[]{UUID_HOURGLASS_RECIPE});
        registry.addRecipeCatalyst((Object)new ItemStack(UCBlocks.cocito), new String[]{UUID_HEATER_RECIPE});
        registry.addRecipeCatalyst((Object)new ItemStack(UCItems.wildwoodStaff), new String[]{UUID_ENCHANTER_RECIPE});
        this.addDescription(registry, UCBlocks.harvestTrap, "harvesttrap");
        this.addDescription(registry, UCItems.emeradicDiamond, "emeradicdiamond");
        this.addDescription(registry, UCItems.wildwoodStaff, "wildwoodstaff");
        this.addDescription(registry, UCItems.pixelBrush, "pixelbrush");
        this.addDescription(registry, (Item)UCItems.precisionAxe, "precisionaxe");
        this.addDescription(registry, (Item)UCItems.precisionPick, "precisionpick");
        this.addDescription(registry, (Item)UCItems.precisionShovel, "precisionshovel");
        this.addDescription(registry, (Item)UCItems.precisionSword, "precisionsword");
        this.addDescription(registry, (Item)UCItems.glasses3D, "3dglasses");
        this.addDescription(registry, (Item)UCItems.poncho, "poncho");
        this.addDescription(registry, (Item)UCItems.thunderPantz, "thunderpantz");
        this.addDescription(registry, (Item)UCItems.pixelGlasses, "pixelglasses");
        this.addDescription(registry, UCItems.ankh, "flintankh");
        IJeiHelpers helpers = registry.getJeiHelpers();
        IIngredientBlacklist blacklist = helpers.getIngredientBlacklist();
        blacklist.addIngredientToBlacklist((Object)EnumItems.DUMMYITEM.createStack());
    }

    private void addDescription(IModRegistry registry, Item item, String str) {
        registry.addIngredientInfo((Object)new ItemStack(item), ItemStack.class, new String[]{"info.jei.uniquecrops." + str});
    }

    private void addDescription(IModRegistry registry, Block block, String str) {
        registry.addIngredientInfo((Object)new ItemStack(block), ItemStack.class, new String[]{"info.jei.uniquecrops." + str});
    }
}

