/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.integration.crafttweaker.mtlib;

import com.bafomdad.uniquecrops.integration.crafttweaker.mtlib.LogHelper;
import crafttweaker.api.block.IBlock;
import crafttweaker.api.item.IItemStack;
import crafttweaker.mc1120.item.MCItemStack;
import java.lang.reflect.Array;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;

public class InputHelper {
    public static ItemStack toStack(IItemStack iStack) {
        if (iStack == null) {
            return ItemStack.field_190927_a;
        }
        Object internal = iStack.getInternal();
        if (!(internal instanceof ItemStack)) {
            LogHelper.logError("Not a valid item stack: " + iStack);
        }
        return (ItemStack)internal;
    }

    public static Block toBlock(IBlock iBlock) {
        if (iBlock == null) {
            return Blocks.field_150350_a;
        }
        Object internal = iBlock.getDefinition().getInternal();
        if (!(internal instanceof Block)) {
            LogHelper.logError("Not a valid block: " + iBlock);
        }
        return (Block)internal;
    }

    public static <T> T[][] getMultiDimensionalArray(Class<T> clazz, T[] array, int height, int width) {
        Object[][] multiDim = (Object[][])Array.newInstance(clazz, height, width);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                multiDim[y][x] = array[x + y * width];
            }
        }
        return multiDim;
    }

    public static ItemStack[] toStacks(IItemStack[] iStack) {
        if (iStack == null) {
            return null;
        }
        ItemStack[] output = new ItemStack[iStack.length];
        for (int i = 0; i < iStack.length; ++i) {
            output[i] = InputHelper.toStack(iStack[i]);
        }
        return output;
    }

    public static IItemStack toIItemStack(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        return new MCItemStack(stack);
    }
}

