/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.dimension;

import com.bafomdad.uniquecrops.init.UCDimension;
import java.util.Iterator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ITeleporter;

public class CropWorldTeleporter
implements ITeleporter {
    public void placeEntity(World world, Entity entity, float yaw) {
        double dist = -1.0;
        int mX = 0;
        int mY = 0;
        int mZ = 0;
        int sX = MathHelper.func_76128_c((double)entity.field_70165_t);
        int sZ = MathHelper.func_76128_c((double)entity.field_70161_v);
        BlockPos playerPos = new BlockPos(sX, 36, sZ);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        boolean flag = world.field_73011_w.getDimension() == UCDimension.dimID;
        int range = 4;
        if (flag) {
            Iterator iterator = BlockPos.MutableBlockPos.func_177975_b((BlockPos)playerPos.func_177982_a(-range, -range, -range), (BlockPos)playerPos.func_177982_a(range, range, range)).iterator();
            while (iterator.hasNext()) {
                if (world.func_175623_d((BlockPos)pos.func_189533_g((Vec3i)iterator.next()))) continue;
                mX = pos.func_177958_n();
                mY = pos.func_177956_o() + 1;
                mZ = pos.func_177952_p();
                break;
            }
            if (mX > 0 && mY > 0 && mZ > 0) {
                entity.field_70181_x = 0.0;
                entity.field_70143_R = 0.0f;
                if (entity instanceof EntityPlayer) {
                    ((EntityPlayer)entity).func_70651_bq().removeIf(p -> "potion.awkward".equals(p.func_76453_d()));
                }
                if (entity instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)entity).field_71135_a.func_147364_a((double)mX + 0.5, (double)mY + 0.5, (double)mZ + 0.5, entity.field_70177_z, entity.field_70125_A);
                } else {
                    entity.func_70012_b((double)mX + 0.5, (double)mY + 0.5, (double)mZ + 0.5, entity.field_70177_z, entity.field_70125_A);
                }
            }
        }
        if (!flag) {
            BlockPos telePos = this.getLastTeleportPosition(entity);
            if (telePos.equals((Object)BlockPos.field_177992_a)) {
                return;
            }
            mX = telePos.func_177958_n();
            mY = telePos.func_177956_o();
            mZ = telePos.func_177952_p();
            entity.field_70181_x = 0.0;
            entity.field_70143_R = 0.0f;
            if (entity instanceof EntityPlayerMP) {
                ((EntityPlayerMP)entity).field_71135_a.func_147364_a((double)mX + 0.5, (double)mY + 0.5, (double)mZ + 0.5, entity.field_70177_z, entity.field_70125_A);
            } else {
                entity.func_70012_b((double)mX + 0.5, (double)mY + 0.5, (double)mZ + 0.5, entity.field_70177_z, entity.field_70125_A);
            }
        }
    }

    private BlockPos getLastTeleportPosition(Entity entity) {
        NBTTagCompound data = entity.getEntityData().func_74775_l("PlayerPersisted");
        if (data != null && data.func_74764_b("UC:LastTeleportPosition")) {
            return BlockPos.func_177969_a((long)data.func_74763_f("UC:LastTeleportPosition"));
        }
        return BlockPos.field_177992_a;
    }

    private boolean shouldTeleportInChunk(int chunkX, int chunkZ) {
        int xOffset = chunkX;
        int zOffset = chunkZ;
        int spacing = 4;
        int clusterSize = 1;
        int width = spacing + clusterSize;
        if (xOffset < 0) {
            xOffset = -xOffset + clusterSize;
        }
        if (zOffset < 0) {
            zOffset = -zOffset + clusterSize;
        }
        return (xOffset %= width) < clusterSize && (zOffset %= width) < clusterSize;
    }
}

