/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.crops;

import com.bafomdad.uniquecrops.blocks.BlockCropsBase;
import com.bafomdad.uniquecrops.blocks.tiles.TileCinderbella;
import com.bafomdad.uniquecrops.core.enums.EnumCrops;
import com.bafomdad.uniquecrops.init.UCItems;
import java.util.Random;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Cinderbella
extends BlockCropsBase
implements ITileEntityProvider {
    public Cinderbella() {
        super(EnumCrops.CINDERBELLA);
        GameRegistry.registerTileEntity(TileCinderbella.class, (ResourceLocation)new ResourceLocation("uniquecrops", "cinderbella"));
    }

    public Item func_149866_i() {
        return UCItems.seedsCinderbella;
    }

    public Item func_149865_P() {
        return UCItems.generic;
    }

    @Override
    public boolean canPlantCrop(World world, EntityPlayer player, EnumFacing side, BlockPos pos, ItemStack stack) {
        return this.canPlantOrGrow(world, pos);
    }

    public int func_180651_a(IBlockState state) {
        if (this.func_185527_x(state) < this.func_185526_g()) {
            return 0;
        }
        return 14;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (this.canIgnoreGrowthRestrictions(world, pos)) {
            super.func_180650_b(world, pos, state, rand);
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileCinderbella) {
            TileCinderbella tile = (TileCinderbella)te;
            long time = world.func_72820_D() % 24000L;
            if (TileCinderbella.plantedCorrect) {
                if (TileCinderbella.timePlanted >= time - 6000L) {
                    super.func_180650_b(world, pos, state, rand);
                    return;
                }
            }
        }
        world.func_180501_a(pos, Blocks.field_150330_I.func_176223_P(), 2);
    }

    @Override
    public void func_176487_g(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileCinderbella) {
            TileCinderbella tile = (TileCinderbella)te;
            if (!world.field_72995_K) {
                if (!TileCinderbella.plantedCorrect) {
                    world.func_180501_a(pos, Blocks.field_150330_I.func_176223_P(), 2);
                    return;
                }
            }
        } else if (te == null) {
            world.func_180501_a(pos, Blocks.field_150330_I.func_176223_P(), 2);
        }
        super.func_176487_g(world, pos, state);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_180501_a(pos, state.func_177230_c().func_176223_P(), 3);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileCinderbella) {
            ((TileCinderbella)te).setAbleToGrow(world);
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileCinderbella();
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        this.createParticles(state, world, pos, rand, EnumParticleTypes.CRIT, 3);
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean canPlantOrGrow(World world, BlockPos pos) {
        long time = world.func_72820_D() % 24000L;
        if (time >= 18000L) {
            return false;
        }
        BlockPos pos1 = pos.func_177984_a();
        int pumpkins = 0;
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            IBlockState pumpkin = world.func_180495_p(pos1.func_177972_a(facing));
            if (world.field_72995_K || pumpkin.func_177230_c() != Blocks.field_150423_aK) continue;
            ++pumpkins;
        }
        return pumpkins >= 4;
    }
}

