/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.core;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.shader.Shader;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.client.shader.ShaderUniform;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="uniquecrops")
public class UCShaderUtil {
    private static final Map<ResourceLocation, ShaderGroup> screenShaders = new HashMap<ResourceLocation, ShaderGroup>();
    private static boolean resetScreenShaders;
    private static int oldDisplayWidth;
    private static int oldDisplayHeight;
    private static final String[] SHADERLIST;
    public static final MethodHandle list_shaders;

    private static boolean shouldUseShaders() {
        return OpenGlHelper.field_148824_g;
    }

    public static void enableScreenShader(ResourceLocation res) {
        if (UCShaderUtil.shouldUseShaders() && !screenShaders.containsKey(res)) {
            try {
                Minecraft mc = Minecraft.func_71410_x();
                resetScreenShaders = true;
                screenShaders.put(res, new ShaderGroup(mc.func_110434_K(), mc.func_110442_L(), mc.func_147110_a(), res));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void disableScreenShader(ResourceLocation res) {
        if (screenShaders.containsKey(res)) {
            screenShaders.remove(res).func_148021_a();
        }
    }

    public static void resetScreenShaders() {
        Minecraft mc = Minecraft.func_71410_x();
        if (resetScreenShaders || mc.field_71443_c != oldDisplayWidth || oldDisplayHeight != mc.field_71440_d) {
            for (ShaderGroup sg : screenShaders.values()) {
                sg.func_148026_a(mc.field_71443_c, mc.field_71440_d);
            }
            oldDisplayWidth = mc.field_71443_c;
            oldDisplayHeight = mc.field_71440_d;
            resetScreenShaders = false;
        }
    }

    public static void setScreenUniform(ResourceLocation res, String uniformName, float value, float ... more) {
        ShaderGroup shaderGroup = screenShaders.get(res);
        if (shaderGroup != null) {
            List shaders;
            try {
                shaders = list_shaders.invokeExact(shaderGroup);
            }
            catch (Throwable t) {
                return;
            }
            block8: for (Shader shader : shaders) {
                ShaderUniform uniform = shader.func_148043_c().func_147984_b(uniformName);
                switch (more.length) {
                    case 0: {
                        uniform.func_148090_a(value);
                        continue block8;
                    }
                    case 1: {
                        uniform.func_148087_a(value, more[0]);
                        continue block8;
                    }
                    case 2: {
                        uniform.func_148095_a(value, more[0], more[1]);
                        continue block8;
                    }
                    case 3: {
                        uniform.func_148081_a(value, more[0], more[1], more[2]);
                        continue block8;
                    }
                }
                throw new IllegalArgumentException("There should be between 1 and 4 values total, got " + more.length);
            }
        }
    }

    @SubscribeEvent
    public static void renderScreenShaders(RenderGameOverlayEvent.Pre event) {
        if (UCShaderUtil.shouldUseShaders() && !screenShaders.isEmpty() && event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            UCShaderUtil.resetScreenShaders();
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179096_D();
            float partialTicks = event.getPartialTicks();
            screenShaders.forEach((key, shaderGroup) -> {
                GlStateManager.func_179094_E();
                shaderGroup.func_148018_a(partialTicks);
                GlStateManager.func_179121_F();
            });
            Minecraft.func_71410_x().func_147110_a().func_147610_a(true);
        }
    }

    static {
        oldDisplayWidth = Minecraft.func_71410_x().field_71443_c;
        oldDisplayHeight = Minecraft.func_71410_x().field_71440_d;
        SHADERLIST = new String[]{"listShaders", "field_148031_d", "d"};
        try {
            Field f = ReflectionHelper.findField(ShaderGroup.class, (String[])SHADERLIST);
            f.setAccessible(true);
            list_shaders = MethodHandles.publicLookup().unreflectGetter(f);
        }
        catch (IllegalAccessException e) {
            System.out.println("[Unique Crops]: Couldn't initialize methodhandles! Things will be broken!");
            e.printStackTrace();
            throw Throwables.propagate((Throwable)e);
        }
    }
}

