/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.blocks.tiles;

import com.bafomdad.uniquecrops.blocks.tiles.TileBaseRenderUC;
import com.bafomdad.uniquecrops.init.UCBlocks;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class TileLacusia
extends TileBaseRenderUC {
    private ItemStackHandler inv = new ItemStackHandler(1);
    private int dir;
    private int waitTime = 10;
    private int waitTimeStuck = 20;
    private static EnumFacing[] REVERSE = new EnumFacing[]{EnumFacing.EAST, EnumFacing.NORTH, EnumFacing.WEST, EnumFacing.SOUTH};

    public void updateStuff() {
        block9: {
            boolean hasPower;
            block10: {
                hasPower = this.field_145850_b.func_175640_z(this.func_174877_v());
                if (this.field_145850_b.field_72995_K) break block9;
                if (!this.canAdd() || !hasPower) break block10;
                TileEntity tileInv = null;
                for (EnumFacing face : EnumFacing.field_176754_o) {
                    BlockPos looppos = this.func_174877_v().func_177972_a(face);
                    if (!this.field_145850_b.func_175667_e(looppos)) {
                        return;
                    }
                    TileEntity tile = this.field_145850_b.func_175625_s(looppos);
                    if (tile == null || !tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face)) continue;
                    tileInv = tile;
                    this.dir = face.func_176745_a();
                    break;
                }
                if (tileInv == null) break block9;
                IItemHandler cap = (IItemHandler)tileInv.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.func_176731_b((int)this.dir));
                for (int i = 0; i < cap.getSlots(); ++i) {
                    ItemStack extract = cap.getStackInSlot(i);
                    if (extract.func_190926_b()) continue;
                    this.setItem(extract.func_77946_l());
                    cap.extractItem(i, extract.func_77976_d(), false);
                    this.markBlockForUpdate();
                    break block9;
                }
                break block9;
            }
            if (!this.canAdd()) {
                boolean schedule = false;
                for (EnumFacing face : hasPower ? REVERSE : EnumFacing.field_176754_o) {
                    if (this.directionMatches(face)) continue;
                    BlockPos looppos = this.func_174877_v().func_177972_a(face);
                    if (!this.field_145850_b.func_175667_e(looppos)) {
                        return;
                    }
                    TileEntity tile = this.field_145850_b.func_175625_s(looppos);
                    if (tile instanceof TileLacusia) {
                        TileLacusia lacusia = (TileLacusia)tile;
                        if (lacusia.canAdd()) {
                            lacusia.setItem(this.getItem());
                            this.setItem(ItemStack.field_190927_a);
                            lacusia.markBlockForUpdate();
                            this.markBlockForUpdate();
                            this.dir = face.func_176745_a();
                            lacusia.dir = face.func_176734_d().func_176745_a();
                            this.field_145850_b.func_175684_a(looppos, (Block)UCBlocks.cropLacusia, this.waitTime);
                            break;
                        }
                        this.dir = face.func_176745_a();
                        this.field_145850_b.func_175684_a(this.func_174877_v(), (Block)UCBlocks.cropLacusia, this.waitTimeStuck);
                    }
                    if (tile == null || !tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face)) continue;
                    IItemHandler cap = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face);
                    int amount = 0;
                    ItemStack simulate = ItemHandlerHelper.insertItem((IItemHandler)cap, (ItemStack)this.getItem().func_77946_l(), (boolean)true);
                    int available = this.getItem().func_190916_E() - simulate.func_190916_E();
                    if (available >= this.getItem().func_190916_E()) {
                        amount = available;
                        ItemHandlerHelper.insertItem((IItemHandler)cap, (ItemStack)this.getItem(), (boolean)false);
                        this.setItem(simulate);
                        this.markBlockForUpdate();
                        this.dir = face.func_176745_a();
                        if (this.getItem().func_190926_b()) break;
                        this.field_145850_b.func_175684_a(this.func_174877_v(), (Block)UCBlocks.cropLacusia, this.waitTime);
                        break;
                    }
                    if (available > 0) continue;
                    this.dir = face.func_176745_a();
                    this.field_145850_b.func_175684_a(this.func_174877_v(), (Block)UCBlocks.cropLacusia, this.waitTimeStuck);
                }
            }
        }
    }

    private boolean directionMatches(EnumFacing facing) {
        return facing.func_176745_a() == this.dir;
    }

    public boolean canAdd() {
        return this.inv.getStackInSlot(0).func_190926_b();
    }

    public ItemStack getItem() {
        return this.inv.getStackInSlot(0);
    }

    public void setItem(ItemStack stack) {
        this.inv.setStackInSlot(0, stack);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound tag) {
        tag.func_74768_a("UC_facing", this.dir);
        tag.func_74782_a("inventory", (NBTBase)this.inv.serializeNBT());
    }

    @Override
    public void readCustomNBT(NBTTagCompound tag) {
        this.dir = tag.func_74762_e("UC_facing");
        this.inv.deserializeNBT(tag.func_74775_l("inventory"));
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        if (packet != null && packet.func_148857_g() != null) {
            this.readCustomNBT(packet.func_148857_g());
        }
        this.markBlockForRenderUpdate();
    }
}

