/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.blocks.tiles;

import com.bafomdad.uniquecrops.blocks.tiles.TileBaseRenderUC;
import java.awt.Color;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;

public class TileHarvestTrap
extends TileBaseRenderUC
implements ITickable {
    private boolean hasSpirit;
    private boolean collectedSpirit;
    private int spiritTime = 0;
    private final int range = 4;

    public void func_73660_a() {
        if (this.spiritTime <= 0) {
            return;
        }
        if (this.collectedSpirit && this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.tickCropGrowth();
            --this.spiritTime;
            if (this.spiritTime <= 0) {
                this.collectedSpirit = false;
                this.markBlockForUpdate();
                return;
            }
        } else if (!this.collectedSpirit) {
            --this.spiritTime;
        }
    }

    public void tickCropGrowth() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        Iterable posList = BlockPos.func_177980_a((BlockPos)this.field_174879_c.func_177982_a(-4, 0, -4), (BlockPos)this.field_174879_c.func_177982_a(4, 1, 4));
        for (BlockPos loopPos : posList) {
            IBlockState loopState = this.field_145850_b.func_180495_p(loopPos);
            if (!(loopState.func_177230_c() instanceof BlockCrops) || ((BlockCrops)loopState.func_177230_c()).func_185525_y(loopState)) continue;
            this.field_145850_b.func_175718_b(2005, loopPos, 0);
            loopState.func_177230_c().func_180650_b(this.field_145850_b, loopPos, loopState, this.field_145850_b.field_73012_v);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound tag) {
        tag.func_74757_a("UC:HasSpirit", this.hasSpirit);
        tag.func_74757_a("UC:CollectedSpirit", this.collectedSpirit);
        tag.func_74768_a("UC:SpiritTime", this.spiritTime);
    }

    @Override
    public void readCustomNBT(NBTTagCompound tag) {
        this.hasSpirit = tag.func_74767_n("UC:HasSpirit");
        this.collectedSpirit = tag.func_74767_n("UC:CollectedSpirit");
        this.spiritTime = tag.func_74762_e("UC:SpiritTime");
    }

    public void setSpiritTime(int time) {
        this.spiritTime = time;
        this.markBlockForUpdate();
    }

    public void setCollected() {
        this.collectedSpirit = true;
    }

    public boolean hasSpirit() {
        return this.spiritTime > 0;
    }

    public boolean isCollected() {
        return this.collectedSpirit;
    }

    public float[] getSpiritColor() {
        float[] fArray;
        if (this.collectedSpirit) {
            float[] fArray2 = new float[3];
            fArray2[0] = (float)Color.GREEN.getRed() / 255.0f;
            fArray2[1] = (float)Color.GREEN.getGreen() / 255.0f;
            fArray = fArray2;
            fArray2[2] = (float)Color.GREEN.getBlue() / 255.0f;
        } else {
            float[] fArray3 = new float[3];
            fArray3[0] = (float)Color.ORANGE.getRed() / 255.0f;
            fArray3[1] = (float)Color.ORANGE.getGreen() / 255.0f;
            fArray = fArray3;
            fArray3[2] = (float)Color.ORANGE.getBlue() / 255.0f;
        }
        return fArray;
    }
}

