/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.uniquecrops.blocks;

import com.bafomdad.uniquecrops.blocks.BlockBaseUC;
import com.bafomdad.uniquecrops.blocks.tiles.TileMirror;
import com.bafomdad.uniquecrops.core.UCConfig;
import com.bafomdad.uniquecrops.entities.EntityMirror;
import com.bafomdad.uniquecrops.init.UCBlocks;
import com.bafomdad.uniquecrops.init.UCItems;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMirror
extends BlockBaseUC {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyEnum<BlockDoor.EnumDoorHalf> HALF = BlockDoor.field_176523_O;
    protected static final AxisAlignedBB NORTHSOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.4375, 1.0, 1.0, 0.5625);
    protected static final AxisAlignedBB EASTWEST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.1875);

    public BlockMirror() {
        super("mirror", Material.field_151594_q);
        this.func_149711_c(0.3f);
        this.func_149752_b(10.0f);
        GameRegistry.registerTileEntity(TileMirror.class, (ResourceLocation)new ResourceLocation("uniquecrops", "mirror"));
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        if (!UCConfig.CropConfig.cropVampire) {
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        if (player.func_184172_bi().func_176734_d() != state.func_177229_b((IProperty)FACING)) {
            return;
        }
        if (!world.field_72995_K) {
            BlockPos newPos = state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.UPPER ? pos.func_177977_b().func_177967_a((EnumFacing)state.func_177229_b((IProperty)FACING), 3) : pos.func_177967_a((EnumFacing)state.func_177229_b((IProperty)FACING), 3);
            Iterable iter = BlockPos.func_177980_a((BlockPos)newPos.func_177982_a(-2, 0, -2), (BlockPos)newPos.func_177982_a(2, 1, 2));
            for (BlockPos loopPos : iter) {
                IBlockState loopState = world.func_180495_p(loopPos);
                if (loopState.func_177230_c() != UCBlocks.cropSucco || (Integer)loopState.func_177229_b((IProperty)BlockCrops.field_176488_a) < UCBlocks.cropSucco.func_185526_g()) continue;
                world.func_72838_d((Entity)new EntityItem(world, (double)loopPos.func_177958_n(), (double)loopPos.func_177956_o(), (double)loopPos.func_177952_p(), new ItemStack(UCItems.vampiricOintment)));
                world.func_175655_b(loopPos, true);
                break;
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!UCConfig.CropConfig.cropVampire) {
            return false;
        }
        if (facing != state.func_177229_b((IProperty)FACING)) {
            return false;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && stack.func_77973_b() == UCItems.seedsSucco) {
            BlockPos newPos = state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.UPPER ? pos.func_177977_b().func_177967_a((EnumFacing)state.func_177229_b((IProperty)FACING), 3) : pos.func_177967_a((EnumFacing)state.func_177229_b((IProperty)FACING), 3);
            Iterable iter = BlockPos.func_177980_a((BlockPos)newPos.func_177982_a(-2, 0, -2), (BlockPos)newPos.func_177982_a(2, 1, 2));
            for (BlockPos loopPos : iter) {
                if (!world.func_175623_d(loopPos) || world.field_72995_K || !(world.func_180495_p(loopPos.func_177977_b()).func_177230_c() instanceof BlockFarmland)) continue;
                world.func_180501_a(loopPos, UCBlocks.cropSucco.func_176223_P(), 3);
                if (player.field_71075_bZ.field_75098_d) break;
                stack.func_190918_g(1);
                break;
            }
            return true;
        }
        return false;
    }

    private EntityMirror getMirrorEntity(World world, BlockPos pos, EnumFacing facing) {
        EntityMirror mirror;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileMirror) {
            EntityMirror mirror2 = ((TileMirror)tile).getMirrorEntity();
            if (mirror2.func_184172_bi() == facing) {
                return mirror2;
            }
        } else if (world.func_175625_s(pos.func_177977_b()) instanceof TileMirror && (mirror = ((TileMirror)world.func_175625_s(pos.func_177977_b())).getMirrorEntity()).func_184172_bi() == facing) {
            return mirror;
        }
        return null;
    }

    private void setPosition(EntityMirror ent, EntityPlayer player) {
        switch (ent.func_184172_bi()) {
            case WEST: {
                ent.func_70080_a(ent.field_70165_t -= 0.5, ent.field_70163_u, ent.field_70161_v, -player.field_70759_as, player.field_70125_A);
                break;
            }
            case EAST: {
                ent.func_70080_a(ent.field_70165_t += 0.5, ent.field_70163_u, ent.field_70161_v, -player.field_70759_as, player.field_70125_A);
                break;
            }
            case NORTH: {
                ent.func_70080_a(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v -= 0.5, -player.field_70759_as, player.field_70125_A);
                break;
            }
            case SOUTH: {
                ent.func_70080_a(ent.field_70165_t -= 0.5, ent.field_70163_u, ent.field_70161_v -= 0.5, -player.field_70759_as, player.field_70125_A);
                break;
            }
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)(state = state.func_185899_b(source, pos)).func_177229_b((IProperty)FACING);
        if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
            return new AxisAlignedBB(0.0, 0.0, 0.4375, 1.0, 1.0, 0.5625);
        }
        return new AxisAlignedBB(0.4375, 0.0, 0.0, 0.5625, 1.0, 1.0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, HALF});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() | (state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.UPPER ? 4 : 0);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a(HALF, (Comparable)((meta & 4) != 0 ? BlockDoor.EnumDoorHalf.UPPER : BlockDoor.EnumDoorHalf.LOWER));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a(HALF, (Comparable)BlockDoor.EnumDoorHalf.LOWER).func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return super.func_176196_c(world, pos) && super.func_176196_c(world, pos.func_177984_a());
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_175656_a(pos.func_177984_a(), this.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)).func_177226_a(HALF, (Comparable)BlockDoor.EnumDoorHalf.UPPER));
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos from) {
        BlockPos pos2;
        IBlockState secondHalf;
        if (block == this && ((secondHalf = world.func_180495_p(pos2 = state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.UPPER ? pos.func_177977_b() : pos.func_177984_a())).func_177230_c() != this || secondHalf.func_177229_b((IProperty)FACING) != state.func_177229_b((IProperty)FACING) || secondHalf.func_177229_b(HALF) == state.func_177229_b(HALF))) {
            world.func_175698_g(pos);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean hasTileEntity(IBlockState state) {
        return state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.LOWER;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileMirror();
    }
}

