/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import twilightforest.capabilities.CapabilityList;
import twilightforest.capabilities.shield.IShieldCapability;
import twilightforest.client.renderer.entity.LayerShields;
import twilightforest.entity.boss.EntityTFLich;
import twilightforest.potions.PotionFrosted;

public enum RenderEffect {
    ICE{
        private final Random random = new Random();

        @Override
        public boolean shouldRender(EntityLivingBase entity, boolean firstPerson) {
            return !firstPerson && entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111127_a(PotionFrosted.MODIFIER_UUID) != null;
        }

        @Override
        public void render(EntityLivingBase entity, RenderLivingBase<? extends EntityLivingBase> renderer, double x, double y, double z, float partialTicks, boolean firstPerson) {
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            this.random.setSeed(entity.func_145782_y() * entity.func_145782_y() * 3121 + entity.func_145782_y() * 45238971);
            int numCubes = (int)(entity.field_70131_O / 0.4f);
            for (int i = 0; i < numCubes; ++i) {
                GlStateManager.func_179094_E();
                float dx = (float)(x + this.random.nextGaussian() * (double)0.2f * (double)entity.field_70130_N);
                float dy = (float)(y + this.random.nextGaussian() * (double)0.2f * (double)entity.field_70131_O) + entity.field_70131_O / 2.0f;
                float dz = (float)(z + this.random.nextGaussian() * (double)0.2f * (double)entity.field_70130_N);
                GlStateManager.func_179109_b((float)dx, (float)dy, (float)dz);
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
                GlStateManager.func_179114_b((float)(this.random.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(this.random.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(this.random.nextFloat() * 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                Minecraft.func_71410_x().func_175602_ab().func_175016_a(Blocks.field_150432_aD.func_176223_P(), 1.0f);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179084_k();
        }
    }
    ,
    SHIELDS{
        private final LayerRenderer<EntityLivingBase> layer = new LayerShields();

        @Override
        public boolean shouldRender(EntityLivingBase entity, boolean firstPerson) {
            if (entity instanceof EntityTFLich) {
                return false;
            }
            IShieldCapability cap = (IShieldCapability)entity.getCapability(CapabilityList.SHIELDS, null);
            return cap != null && cap.shieldsLeft() > 0;
        }

        @Override
        public void render(EntityLivingBase entity, RenderLivingBase<? extends EntityLivingBase> renderer, double x, double y, double z, float partialTicks, boolean firstPerson) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)(0.5f - entity.func_70047_e()), (float)0.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_179129_p();
            GlStateManager.func_179112_b((int)770, (int)771);
            this.layer.func_177141_a(entity, 0.0f, 0.0f, partialTicks, 0.0f, 0.0f, 0.0f, 0.0625f);
            GlStateManager.func_179089_o();
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    };

    static final RenderEffect[] VALUES;

    public boolean shouldRender(EntityLivingBase entity, boolean firstPerson) {
        return false;
    }

    public void render(EntityLivingBase entity, RenderLivingBase<? extends EntityLivingBase> renderer, double x, double y, double z, float partialTicks, boolean firstPerson) {
    }

    static {
        VALUES = RenderEffect.values();
    }
}

