/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.client.gui;

import com.cazsius.solcarrot.SOLCarrot;
import com.cazsius.solcarrot.client.gui.ConfigInfoPage;
import com.cazsius.solcarrot.client.gui.FoodData;
import com.cazsius.solcarrot.client.gui.ItemListPage;
import com.cazsius.solcarrot.client.gui.Page;
import com.cazsius.solcarrot.client.gui.PageFlipButton;
import com.cazsius.solcarrot.client.gui.StatListPage;
import com.cazsius.solcarrot.client.gui.elements.UIElement;
import com.cazsius.solcarrot.client.gui.elements.UIImage;
import com.cazsius.solcarrot.client.gui.elements.UILabel;
import com.cazsius.solcarrot.lib.Localization;
import com.cazsius.solcarrot.tracking.FoodList;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class GuiFoodBook
extends GuiScreen {
    private static final ResourceLocation texture = SOLCarrot.resourceLocation("textures/gui/food_book.png");
    private static final UIImage.Image bookImage = new UIImage.Image(texture, new Rectangle(0, 0, 186, 192));
    static final UIImage.Image carrotImage = new UIImage.Image(texture, new Rectangle(0, 240, 16, 16));
    static final UIImage.Image spiderEyeImage = new UIImage.Image(texture, new Rectangle(16, 240, 16, 16));
    static final UIImage.Image heartImage = new UIImage.Image(texture, new Rectangle(0, 224, 15, 15));
    static final UIImage.Image drumstickImage = new UIImage.Image(texture, new Rectangle(16, 224, 15, 15));
    static final UIImage.Image blacklistImage = new UIImage.Image(texture, new Rectangle(32, 224, 15, 15));
    static final UIImage.Image whitelistImage = new UIImage.Image(texture, new Rectangle(48, 224, 15, 15));
    static final Color fullBlack = Color.BLACK;
    static final Color lessBlack = new Color(0, 0, 0, 128);
    static final Color leastBlack = new Color(0, 0, 0, 64);
    private final List<UIElement> elements = new ArrayList<UIElement>();
    private UIImage background;
    private UILabel pageNumberLabel;
    private PageFlipButton nextPageButton;
    private PageFlipButton prevPageButton;
    private EntityPlayer player;
    private FoodData foodData;
    private final List<Page> pages = new ArrayList<Page>();
    private int currentPageNumber = 0;

    public GuiFoodBook(EntityPlayer player) {
        this.player = player;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.foodData = new FoodData(FoodList.get(this.player));
        this.background = new UIImage(bookImage);
        this.background.setCenterX(this.field_146294_l / 2);
        this.background.setCenterY(this.field_146295_m / 2);
        this.elements.clear();
        this.pageNumberLabel = new UILabel("1");
        this.pageNumberLabel.setCenterX(this.background.getCenterX());
        this.pageNumberLabel.setMinY(this.background.getMinY() + 156);
        this.elements.add(this.pageNumberLabel);
        this.initPages();
        this.field_146292_n.clear();
        int pageFlipButtonSpacing = 50;
        this.prevPageButton = (PageFlipButton)this.func_189646_b(new PageFlipButton(1, this.background.getCenterX() - pageFlipButtonSpacing / 2 - 23, this.background.getMinY() + 152, PageFlipButton.Direction.BACKWARD));
        this.nextPageButton = (PageFlipButton)this.func_189646_b(new PageFlipButton(2, this.background.getCenterX() + pageFlipButtonSpacing / 2, this.background.getMinY() + 152, PageFlipButton.Direction.FORWARD));
        this.updateButtonVisibility();
    }

    private void initPages() {
        this.pages.clear();
        this.pages.add(new StatListPage(this.foodData, this.background.frame));
        this.pages.add(new ConfigInfoPage(this.foodData, this.background.frame));
        this.addPages("eaten_foods", this.foodData.eatenFoods);
        if (this.foodData.progressInfo.configInfo.shouldShowUneatenFoods) {
            this.addPages("uneaten_foods", this.foodData.uneatenFoods);
        }
    }

    private void addPages(String headerLocalizationPath, List<ItemStack> items) {
        String header = Localization.localized("gui", "food_book." + headerLocalizationPath, items.size());
        this.pages.addAll(ItemListPage.pages(this.background.frame, header, items));
    }

    private void updateButtonVisibility() {
        this.nextPageButton.field_146125_m = this.currentPageNumber < this.pages.size() - 1;
        this.prevPageButton.field_146125_m = this.currentPageNumber > 0;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        UIElement.render(this.background, mouseX, mouseY);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        UIElement.render(this.elements, mouseX, mouseY);
        UIElement.render(this.pages.get(this.currentPageNumber), mouseX, mouseY);
    }

    protected void func_146284_a(GuiButton button) {
        if (!button.field_146124_l) {
            return;
        }
        if (button == this.prevPageButton) {
            --this.currentPageNumber;
            this.updateButtonVisibility();
        } else if (button == this.nextPageButton) {
            ++this.currentPageNumber;
            this.updateButtonVisibility();
        }
        this.pageNumberLabel.text = "" + (this.currentPageNumber + 1);
    }
}

