/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.client.gui;

import com.cazsius.solcarrot.client.FoodItemStacks;
import com.cazsius.solcarrot.client.gui.FoodData;
import com.cazsius.solcarrot.client.gui.GuiFoodBook;
import com.cazsius.solcarrot.client.gui.Page;
import com.cazsius.solcarrot.client.gui.elements.UIElement;
import com.cazsius.solcarrot.client.gui.elements.UIImage;
import com.cazsius.solcarrot.lib.Localization;
import com.cazsius.solcarrot.tracking.FoodInstance;
import com.cazsius.solcarrot.tracking.ProgressInfo;
import java.awt.Rectangle;
import net.minecraft.item.ItemStack;

final class ConfigInfoPage
extends Page {
    ConfigInfoPage(FoodData foodData, Rectangle frame) {
        super(frame, Localization.localized("gui", "food_book.config", new Object[0]));
        ProgressInfo.ConfigInfo configInfo = foodData.progressInfo.configInfo;
        int totalFoods = FoodItemStacks.getAllFoods().size();
        int validFoods = foodData.validFoods.size();
        int cheapFoods = totalFoods - validFoods;
        int eatenCheapFoods = (int)foodData.foodList.getEatenFoods().stream().map(FoodInstance::getItemStack).filter(food -> configInfo.isAllowed((ItemStack)food) && !configInfo.isHearty((ItemStack)food)).count();
        UIImage drumstickIcon = this.icon(GuiFoodBook.drumstickImage);
        int minValue = configInfo.minimumFoodValue;
        String minValueDesc = "" + minValue / 2;
        if (minValue % 2 == 1) {
            minValueDesc = minValueDesc + ".5";
        }
        UIElement minValueStat = this.statWithIcon(drumstickIcon, minValueDesc, Localization.localized("gui", "food_book.config.minimum_food_value", new Object[0]));
        minValueStat.tooltip = Localization.localized("gui", "food_book.config.tooltip.minimum_food_value", new Object[0]);
        this.mainStack.addChild(minValueStat);
        UIImage cheapIcon = this.icon(GuiFoodBook.spiderEyeImage);
        cheapIcon.setWidth(12);
        UIElement cheapStat = this.statWithIcon(cheapIcon, this.fraction(eatenCheapFoods, cheapFoods), Localization.localized("gui", "food_book.config.eaten_cheap_foods", new Object[0]));
        cheapStat.tooltip = Localization.localized("gui", "food_book.config.tooltip.eaten_cheap_foods", cheapFoods, eatenCheapFoods);
        this.mainStack.addChild(cheapStat);
        this.mainStack.addChild(this.makeSeparatorLine());
        boolean hasWhitelist = configInfo.hasWhitelist();
        String listKey = hasWhitelist ? "whitelist" : "blacklist";
        UIImage listIcon = this.icon(hasWhitelist ? GuiFoodBook.whitelistImage : GuiFoodBook.blacklistImage);
        int allFoods = FoodItemStacks.getAllFoodsIgnoringBlacklist().size();
        int allowedFoods = FoodItemStacks.getAllFoods().size();
        String fraction = hasWhitelist ? this.fraction(allowedFoods, allFoods) : this.fraction(allFoods - allowedFoods, allFoods);
        UIElement listStat = this.statWithIcon(listIcon, fraction, Localization.localized("gui", "food_book.config." + listKey, new Object[0]));
        listStat.tooltip = Localization.localized("gui", "food_book.config.tooltip." + listKey, new Object[0]);
        this.mainStack.addChild(listStat);
        this.mainStack.addChild(this.makeSeparatorLine());
        this.updateMainStack();
    }
}

