/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.modIntegration;

import gollorum.signpost.Signpost;
import gollorum.signpost.modIntegration.ModHandler;
import gollorum.signpost.util.BaseInfo;
import gollorum.signpost.util.StonedHashSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Set;
import net.blay09.mods.waystones.GlobalWaystones;
import net.blay09.mods.waystones.PlayerWaystoneHelper;
import net.blay09.mods.waystones.WaystoneManager;
import net.blay09.mods.waystones.block.BlockWaystone;
import net.blay09.mods.waystones.block.TileWaystone;
import net.blay09.mods.waystones.client.ClientWaystones;
import net.blay09.mods.waystones.util.WaystoneEntry;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

public class WaystonesModHandler
implements ModHandler {
    public WaystonesModHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getState().func_177230_c() instanceof BlockWaystone) {
            TileWaystone tile = ((BlockWaystone)event.getState().func_177230_c()).getTileWaystone(event.getWorld(), event.getPos());
            WaystoneEntry entry = new WaystoneEntry(tile);
            GlobalWaystones.get((World)event.getWorld()).removeGlobalWaystone(entry);
            for (EntityPlayer player : Signpost.proxy.getAllPlayers()) {
                WaystoneManager.sendPlayerWaystones((EntityPlayer)player);
            }
        }
    }

    @Override
    public Set<BaseInfo> getAllBaseInfos() {
        Set<BaseInfo> ret = this.getGlobal();
        ret.addAll(this.getNotGlobalByAllPlayers());
        return ret;
    }

    @Override
    public Set<BaseInfo> getAllBaseInfosByPlayer(EntityPlayer player) {
        Set<BaseInfo> ret = this.getGlobal();
        ret.addAll(this.getNotGlobalByPlayer(player));
        return ret;
    }

    private Set<BaseInfo> getGlobal() {
        StonedHashSet ret = new StonedHashSet();
        if (FMLCommonHandler.instance().getEffectiveSide().equals((Object)Side.CLIENT)) {
            for (WaystoneEntry entry : ClientWaystones.getKnownWaystones()) {
                if (!this.validateWaystone(entry)) continue;
                ret.add(this.baseInfoFromWaystoneEntry(entry));
            }
        } else {
            for (World world : Signpost.proxy.getWorlds()) {
                try {
                    for (WaystoneEntry entry : GlobalWaystones.get((World)world).getGlobalWaystones()) {
                        ret.add(this.baseInfoFromWaystoneEntry(entry));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return ret;
    }

    private Set<BaseInfo> getNotGlobalByPlayer(EntityPlayer player) {
        StonedHashSet ret = new StonedHashSet();
        try {
            NBTTagCompound tagCompound = PlayerWaystoneHelper.getWaystonesTag((EntityPlayer)player);
            ret.addAll(this.getNotGlobalByTagCompound(tagCompound));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    private Set<BaseInfo> getNotGlobalByAllPlayers() {
        StonedHashSet ret = new StonedHashSet();
        for (EntityPlayer player : Signpost.proxy.getAllPlayers()) {
            ret.addAll(this.getNotGlobalByPlayer(player));
        }
        if (FMLCommonHandler.instance().getEffectiveSide().equals((Object)Side.CLIENT)) {
            return ret;
        }
        File playerDirectory = new File(DimensionManager.getWorld((int)0).func_72860_G().func_75765_b(), "playerdata");
        if (playerDirectory.isDirectory()) {
            for (File file : playerDirectory.listFiles()) {
                try {
                    FileInputStream stream = new FileInputStream(file);
                    NBTTagCompound tagCompound = CompressedStreamTools.func_74796_a((InputStream)stream);
                    tagCompound = tagCompound.func_74775_l("ForgeData").func_74775_l("PlayerPersisted").func_74775_l("Waystones");
                    stream.close();
                    Set<BaseInfo> bases = this.getNotGlobalByTagCompound(tagCompound);
                    ret.addAll(bases);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return ret;
    }

    private Set<BaseInfo> getNotGlobalByTagCompound(NBTTagCompound tagCompound) {
        StonedHashSet ret = new StonedHashSet();
        NBTTagList tagList = tagCompound.func_150295_c("WaystoneList", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound entryCompound = tagList.func_150305_b(i);
            WaystoneEntry entry = WaystoneEntry.read((NBTTagCompound)entryCompound);
            if (!this.validateWaystone(entry)) continue;
            BaseInfo wrappedWaystone = this.baseInfoFromWaystoneEntry(entry);
            ret.add(wrappedWaystone);
        }
        return ret;
    }

    private boolean validateWaystone(WaystoneEntry entry) {
        try {
            if (FMLCommonHandler.instance().getEffectiveSide().equals((Object)Side.SERVER)) {
                WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(entry.getDimensionId());
                Block block = world.func_180495_p(entry.getPos()).func_177230_c();
                return block instanceof BlockWaystone;
            }
            World world = Signpost.proxy.getWorlds()[0];
            if (world.field_73011_w.getDimension() == entry.getDimensionId()) {
                Block block = world.func_180495_p(entry.getPos()).func_177230_c();
                return block instanceof BlockWaystone;
            }
            return true;
        }
        catch (Exception e) {
            return true;
        }
    }

    private BaseInfo baseInfoFromWaystoneEntry(WaystoneEntry entry) {
        if (entry == null) {
            return null;
        }
        String name = entry.getName();
        int blockX = entry.getPos().func_177958_n();
        int blockY = entry.getPos().func_177956_o();
        int blockZ = entry.getPos().func_177952_p();
        int teleX = blockX + 1;
        int teleY = blockY;
        int teleZ = blockZ;
        int dim = entry.getDimensionId();
        return BaseInfo.fromExternal(name, blockX, blockY, blockZ, teleX, teleY, teleZ, dim, "waystones");
    }
}

