/*
 * Decompiled with CFR 0.152.
 */
package com.mrtrollnugnug.ropebridge.handler;

import com.mrtrollnugnug.ropebridge.block.RopeLadder;
import com.mrtrollnugnug.ropebridge.block.TileEntityRopeLadder;
import com.mrtrollnugnug.ropebridge.handler.ConfigurationHandler;
import com.mrtrollnugnug.ropebridge.handler.ContentHandler;
import com.mrtrollnugnug.ropebridge.lib.ModUtils;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class LadderBuildingHandler {
    public static void newLadder(BlockPos start, EntityPlayer player, World world, EnumFacing hitSide, ItemStack builder) {
        if (!hitSide.func_176740_k().func_176722_c()) {
            ModUtils.tellPlayer((ICommandSender)player, "chat.ropebridge.info.bad_side", hitSide == EnumFacing.UP ? I18n.func_135052_a((String)"chat.ropebridge.params.top", (Object[])new Object[0]) : I18n.func_135052_a((String)"chat.ropebridge.params.bottom", (Object[])new Object[0]));
            return;
        }
        if (!world.isSideSolid(start.func_177972_a(hitSide.func_176734_d()), hitSide)) {
            ModUtils.tellPlayer((ICommandSender)player, "chat.ropebridge.info.not_solid", new Object[0]);
            return;
        }
        int count = 0;
        BlockPos lower = start;
        IBlockState state = world.func_180495_p(lower);
        while (state.func_177230_c().func_176200_f((IBlockAccess)world, lower)) {
            ++count;
            lower = lower.func_177977_b();
            state = world.func_180495_p(lower);
        }
        if (count <= 0) {
            ModUtils.tellPlayer((ICommandSender)player, "chat.ropebridge.info.obstruction", new Object[0]);
            return;
        }
        int woodNeeded = count * ConfigurationHandler.getWoodPerBlock();
        int ropeNeeded = count * ConfigurationHandler.getRopePerBlock();
        BlockPlanks.EnumType woodType = LadderBuildingHandler.findType(player);
        RopeLadder.EnumType type = LadderBuildingHandler.convertType(woodType);
        if (!player.field_71075_bZ.field_75098_d) {
            if (type == null || !LadderBuildingHandler.hasMaterials(player, woodNeeded, ropeNeeded, woodType)) {
                ModUtils.tellPlayer((ICommandSender)player, "chat.ropebridge.info.underfunded_ladder", woodNeeded, ropeNeeded);
                return;
            }
        } else if (type == null) {
            type = RopeLadder.EnumType.OAK;
        }
        LadderBuildingHandler.consume(player, woodNeeded, ropeNeeded, woodType);
        LadderBuildingHandler.build(world, start, count, hitSide, type);
    }

    private static void build(World world, BlockPos start, int count, EnumFacing facing, RopeLadder.EnumType type) {
        LadderBuildingHandler.build(world, start, count, 0, facing, type);
    }

    private static void build(final World world, final BlockPos start, final int count, final int it, final EnumFacing facing, final RopeLadder.EnumType type) {
        FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(() -> {
            IBlockState state = ContentHandler.blockRopeLadder.func_176223_P().func_177226_a((IProperty)RopeLadder.field_176382_a, (Comparable)facing).func_177226_a(RopeLadder.TYPE, (Comparable)((Object)type));
            world.func_175656_a(start.func_177979_c(it), state);
            world.func_175690_a(start.func_177979_c(it), (TileEntity)new TileEntityRopeLadder(type));
        });
        if (it + 1 < count) {
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    LadderBuildingHandler.build(world, start, count, it + 1, facing, type);
                }
            }, 100L);
        }
    }

    private static void consume(EntityPlayer player, int woodNeeded, int ropeNeeded, BlockPlanks.EnumType woodType) {
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        player.field_71071_by.func_174925_a(ContentHandler.itemRope, -1, ropeNeeded, null);
        player.field_71071_by.func_174925_a(Item.func_150898_a((Block)Blocks.field_150376_bx), woodType.func_176839_a(), woodNeeded, null);
    }

    private static RopeLadder.EnumType convertType(BlockPlanks.EnumType type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case ACACIA: {
                return RopeLadder.EnumType.ACACIA;
            }
            case BIRCH: {
                return RopeLadder.EnumType.BIRCH;
            }
            case DARK_OAK: {
                return RopeLadder.EnumType.DARK_OAK;
            }
            case JUNGLE: {
                return RopeLadder.EnumType.JUNGLE;
            }
            case OAK: {
                return RopeLadder.EnumType.OAK;
            }
            case SPRUCE: {
                return RopeLadder.EnumType.SPRUCE;
            }
        }
        return null;
    }

    private static BlockPlanks.EnumType findType(EntityPlayer player) {
        for (ItemStack i : player.field_71071_by.field_70462_a) {
            if (i == null || i.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150376_bx)) continue;
            return (BlockPlanks.EnumType)Blocks.field_150376_bx.func_185674_a(i);
        }
        return player.field_71075_bZ.field_75098_d ? BlockPlanks.EnumType.OAK : null;
    }

    private static boolean hasMaterials(EntityPlayer player, int woodNeeded, int ropeNeeded, BlockPlanks.EnumType toFind) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        for (ItemStack i : player.field_71071_by.field_70462_a) {
            if (i == null) continue;
            Item it = i.func_77973_b();
            if (it == ContentHandler.itemRope) {
                ropeNeeded -= i.func_190916_E();
                continue;
            }
            if (it != Item.func_150898_a((Block)Blocks.field_150376_bx) || toFind != Blocks.field_150376_bx.func_185674_a(i)) continue;
            woodNeeded -= i.func_190916_E();
        }
        return woodNeeded <= 0 && ropeNeeded <= 0;
    }
}

