/*
 * Decompiled with CFR 0.152.
 */
package com.mrtrollnugnug.ropebridge.handler;

import java.io.File;
import net.minecraftforge.common.config.Configuration;

public final class ConfigurationHandler {
    private static Configuration config = null;
    private static int maxBridgeDistance;
    private static int bridgeDroopFactor;
    private static float bridgeYOffset;
    private static boolean breakThroughBlocks;
    private static boolean ignoreSlopeWarnings;
    private static int slabsPerBlock;
    private static int stringPerBlock;
    private static int woodPerBlock;
    private static int ropePerBlock;

    public static void initConfig(File file) {
        ConfigurationHandler.setConfig(new Configuration(file));
        ConfigurationHandler.syncConfig();
    }

    public static void syncConfig() {
        ConfigurationHandler.setMaxBridgeDistance(ConfigurationHandler.getConfig().getInt("maxBridgeDistance", "general", 400, 1, 1000, "Max length of bridges made be Grappling Gun."));
        ConfigurationHandler.setBridgeDroopFactor(ConfigurationHandler.getConfig().getInt("bridgeDroopFactor", "general", 100, 0, 100, "Percent of slack the bridge will have, causing it to hang."));
        ConfigurationHandler.setBridgeYOffset(ConfigurationHandler.getConfig().getFloat("bridgeYOffset", "general", -0.3f, -1.0f, 1.0f, "Generated bridges will be raised or lowered by this ammount in blocks.\nDefault is just below user's feet."));
        ConfigurationHandler.setBreakThroughBlocks(ConfigurationHandler.getConfig().getBoolean("breakThroughBlocks", "general", false, "If enabled, all blocks that dare stand in a bridge's way will be broken.\nVery useful in creative mode."));
        ConfigurationHandler.setIgnoreSlopeWarnings(ConfigurationHandler.getConfig().getBoolean("ignoreSlopeWarnings", "general", false, "Set true to ignore all slope warnings and allow building of very steep bridges."));
        ConfigurationHandler.setSlabsPerBlock(ConfigurationHandler.getConfig().getInt("slabsPerBlock", "general", 1, 0, 10, "Slabs consumed for each bridge block built."));
        ConfigurationHandler.setStringPerBlock(ConfigurationHandler.getConfig().getInt("stringPerBlock", "general", 2, 0, 20, "String consumed for each bridge block built."));
        ConfigurationHandler.setWoodPerBlock(ConfigurationHandler.getConfig().getInt("woodPerBlock", "general", 1, 0, 10, "Wood consumed for each ladder block built."));
        ConfigurationHandler.setRopePerBlock(ConfigurationHandler.getConfig().getInt("ropePerBlock", "general", 2, 0, 20, "Rope consumed for each ladder block built."));
        if (ConfigurationHandler.getConfig().hasChanged()) {
            ConfigurationHandler.getConfig().save();
        }
    }

    public static Configuration getConfig() {
        return config;
    }

    public static void setConfig(Configuration config) {
        ConfigurationHandler.config = config;
    }

    public static boolean isIgnoreSlopeWarnings() {
        return ignoreSlopeWarnings;
    }

    public static void setIgnoreSlopeWarnings(boolean ignoreSlopeWarnings) {
        ConfigurationHandler.ignoreSlopeWarnings = ignoreSlopeWarnings;
    }

    public static int getBridgeDroopFactor() {
        return bridgeDroopFactor;
    }

    public static void setBridgeDroopFactor(int bridgeDroopFactor) {
        ConfigurationHandler.bridgeDroopFactor = bridgeDroopFactor;
    }

    public static float getBridgeYOffset() {
        return bridgeYOffset;
    }

    public static void setBridgeYOffset(float bridgeYOffset) {
        ConfigurationHandler.bridgeYOffset = bridgeYOffset;
    }

    public static boolean isBreakThroughBlocks() {
        return breakThroughBlocks;
    }

    public static void setBreakThroughBlocks(boolean breakThroughBlocks) {
        ConfigurationHandler.breakThroughBlocks = breakThroughBlocks;
    }

    public static int getMaxBridgeDistance() {
        return maxBridgeDistance;
    }

    public static void setMaxBridgeDistance(int maxBridgeDistance) {
        ConfigurationHandler.maxBridgeDistance = maxBridgeDistance;
    }

    public static void setRopePerBlock(int ropePerBlock) {
        ConfigurationHandler.ropePerBlock = ropePerBlock;
    }

    public static void setSlabsPerBlock(int slabsPerBlock) {
        ConfigurationHandler.slabsPerBlock = slabsPerBlock;
    }

    public static void setStringPerBlock(int stringPerBlock) {
        ConfigurationHandler.stringPerBlock = stringPerBlock;
    }

    public static void setWoodPerBlock(int woodPerBlock) {
        ConfigurationHandler.woodPerBlock = woodPerBlock;
    }

    public static int getRopePerBlock() {
        return ropePerBlock;
    }

    public static int getSlabsPerBlock() {
        return slabsPerBlock;
    }

    public static int getStringPerBlock() {
        return stringPerBlock;
    }

    public static int getWoodPerBlock() {
        return woodPerBlock;
    }
}

