/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomtweaks.common;

import com.therandomlabs.randomtweaks.config.RTConfig;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.entity.living.LivingPackSizeEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="randomtweaks")
public final class SquidHandler {
    public static final int RADIUS_LIMIT_DISABLED = 0;
    public static final int CHUNK_LIMIT_DISABLED = -1;
    public static final int SQUID_SPAWNING_DISABLED = 0;
    public static final int VANILLA_PACK_SIZE = 0;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingEntityPackSpawn(LivingPackSizeEvent event) {
        Entity entity = event.getEntity();
        if (entity.getClass() == EntitySquid.class && RTConfig.Squids.maxPackSize != 0) {
            event.setMaxPackSize(RTConfig.Squids.maxPackSize);
        }
    }

    @SubscribeEvent
    public static void onCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (event.getEntity().getClass() == EntitySquid.class && (!SquidHandler.isInRadiusOfPlayer(event) || SquidHandler.tooManySquids(event))) {
            event.setResult(Event.Result.DENY);
        }
    }

    public static boolean isInRadiusOfPlayer(LivingSpawnEvent.CheckSpawn event) {
        int radius = RTConfig.Squids.spawnRadiusLimit;
        if (radius == 0) {
            return true;
        }
        float x = event.getX();
        float y = event.getY();
        float z = event.getZ();
        AxisAlignedBB aabb = new AxisAlignedBB((double)x, (double)y, (double)z, (double)x, (double)y, (double)z).func_72321_a((double)radius, (double)radius, (double)radius);
        for (EntityPlayer player : event.getWorld().field_73010_i) {
            if (!player.func_174813_aQ().func_72326_a(aabb)) continue;
            return true;
        }
        return false;
    }

    public static boolean tooManySquids(LivingSpawnEvent.CheckSpawn event) {
        if (RTConfig.Squids.chunkLimit == 0) {
            return true;
        }
        if (RTConfig.Squids.chunkLimit == -1) {
            return false;
        }
        World world = event.getWorld();
        Chunk chunk = world.func_175726_f(event.getEntity().func_180425_c());
        int squids = 0;
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            Entity entity = (Entity)world.field_72996_f.get(i);
            if (entity.getClass() != EntitySquid.class || entity.field_70176_ah != chunk.field_76635_g || entity.field_70164_aj != chunk.field_76647_h || ++squids < RTConfig.Squids.chunkLimit) continue;
            return true;
        }
        return false;
    }
}

