/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab;

import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import com.wuest.prefab.Prefab;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import javax.imageio.ImageIO;

public class ZipUtil {
    public static byte[] compressString(String originalString) {
        if (originalString == null || originalString.length() == 0) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzip = new GZIPOutputStream(out);
            gzip.write(originalString.getBytes());
            gzip.close();
            byte[] compressed = out.toByteArray();
            out.close();
            return compressed;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String decompressString(byte[] compressedString) {
        ByteArrayInputStream bis = new ByteArrayInputStream(compressedString);
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            GZIPInputStream gis = new GZIPInputStream(bis);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)gis, "UTF-8"));
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            br.close();
            gis.close();
            bis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static byte[] decompressBytes(byte[] compressedBytes) {
        try {
            Inflater decompressor = new Inflater();
            decompressor.setInput(compressedBytes);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(compressedBytes.length);
            byte[] buf = new byte[1024];
            while (!decompressor.finished()) {
                int count = decompressor.inflate(buf);
                bos.write(buf, 0, count);
            }
            bos.close();
            return bos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (DataFormatException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void zipResourceToFile(String resourceLocation, String fileLocation) {
        InputStream stream = Prefab.class.getClassLoader().getResourceAsStream(resourceLocation);
        try {
            String temp = CharStreams.toString((Readable)new InputStreamReader(stream, Charsets.UTF_8.name()));
            stream.close();
            ZipUtil.zipStringToFile(temp, fileLocation);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void zipStringToFile(String value, String fileLocation) {
        try {
            byte[] compressed = ZipUtil.compressString(value);
            Files.write((byte[])compressed, (File)new File(fileLocation));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String decompressResource(String resourceLocation) {
        InputStream stream = Prefab.class.getClassLoader().getResourceAsStream(resourceLocation);
        String returnValue = "";
        try {
            byte[] buf = ByteStreams.toByteArray((InputStream)stream);
            returnValue = ZipUtil.decompressString(buf);
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return returnValue;
    }

    public static BufferedImage decompressImageResource(String resourceLocation) {
        InputStream stream = Prefab.class.getClassLoader().getResourceAsStream(resourceLocation);
        BufferedImage returnValue = null;
        try {
            byte[] buf = ByteStreams.toByteArray((InputStream)stream);
            buf = ZipUtil.decompressBytes(buf);
            stream.close();
            returnValue = ImageIO.read(new ByteArrayInputStream(buf));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return returnValue;
    }
}

