/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Predefined;

import com.wuest.prefab.Structures.Base.BuildBlock;
import com.wuest.prefab.Structures.Base.BuildClear;
import com.wuest.prefab.Structures.Base.Structure;
import com.wuest.prefab.Structures.Config.InstantBridgeConfiguration;
import com.wuest.prefab.Structures.Config.StructureConfiguration;
import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class StructureInstantBridge
extends Structure {
    public static StructureInstantBridge CreateInstance() {
        StructureInstantBridge structure = new StructureInstantBridge();
        return structure;
    }

    @Override
    public boolean BuildStructure(StructureConfiguration configuration, World world, BlockPos originalPos, EnumFacing assumedNorth, EntityPlayer player) {
        InstantBridgeConfiguration specificConfig = (InstantBridgeConfiguration)configuration;
        this.setupClearSpace(specificConfig);
        this.setupStructure(specificConfig, originalPos);
        return super.BuildStructure(specificConfig, world, originalPos, assumedNorth, player);
    }

    public void setupStructure(InstantBridgeConfiguration configuration, BlockPos originalPos) {
        ArrayList<BuildBlock> buildingBlocks = new ArrayList<BuildBlock>();
        IBlockState materialState = configuration.bridgeMaterial.getBlockType();
        EnumFacing facing = EnumFacing.SOUTH;
        IBlockState torchState = Blocks.field_150478_aa.func_176223_P();
        IBlockState glassState = Blocks.field_150410_aZ.func_176223_P();
        int interiorHeightOffSet = configuration.interiorHeight - 3;
        for (int i = 1; i <= configuration.bridgeLength; ++i) {
            BlockPos currentPos = originalPos.func_177967_a(facing, i);
            buildingBlocks.add(Structure.createBuildBlockFromBlockState(materialState, materialState.func_177230_c(), currentPos.func_177967_a(facing.func_176735_f(), 2), originalPos));
            buildingBlocks.add(Structure.createBuildBlockFromBlockState(materialState, materialState.func_177230_c(), currentPos.func_177972_a(facing.func_176735_f()), originalPos));
            buildingBlocks.add(Structure.createBuildBlockFromBlockState(materialState, materialState.func_177230_c(), currentPos, originalPos));
            buildingBlocks.add(Structure.createBuildBlockFromBlockState(materialState, materialState.func_177230_c(), currentPos.func_177972_a(facing.func_176746_e()), originalPos));
            buildingBlocks.add(Structure.createBuildBlockFromBlockState(materialState, materialState.func_177230_c(), currentPos.func_177967_a(facing.func_176746_e(), 2), originalPos));
            buildingBlocks.add(Structure.createBuildBlockFromBlockState(materialState, materialState.func_177230_c(), currentPos.func_177967_a(facing.func_176735_f(), 2).func_177984_a(), originalPos));
            buildingBlocks.add(Structure.createBuildBlockFromBlockState(materialState, materialState.func_177230_c(), currentPos.func_177967_a(facing.func_176746_e(), 2).func_177984_a(), originalPos));
            if (configuration.includeRoof) {
                buildingBlocks.add(Structure.createBuildBlockFromBlockState(materialState, materialState.func_177230_c(), currentPos.func_177967_a(facing.func_176735_f(), 2).func_177981_b(3 + interiorHeightOffSet), originalPos));
                buildingBlocks.add(Structure.createBuildBlockFromBlockState(materialState, materialState.func_177230_c(), currentPos.func_177972_a(facing.func_176735_f()).func_177981_b(4 + interiorHeightOffSet), originalPos));
                buildingBlocks.add(Structure.createBuildBlockFromBlockState(materialState, materialState.func_177230_c(), currentPos.func_177981_b(4 + interiorHeightOffSet), originalPos));
                buildingBlocks.add(Structure.createBuildBlockFromBlockState(materialState, materialState.func_177230_c(), currentPos.func_177972_a(facing.func_176746_e()).func_177981_b(4 + interiorHeightOffSet), originalPos));
                buildingBlocks.add(Structure.createBuildBlockFromBlockState(materialState, materialState.func_177230_c(), currentPos.func_177967_a(facing.func_176746_e(), 2).func_177981_b(3 + interiorHeightOffSet), originalPos));
            }
            for (int j = 0; j <= interiorHeightOffSet; ++j) {
                if ((i == 1 || i % 6 == 0) && j == 0) {
                    buildingBlocks.add(Structure.createBuildBlockFromBlockState(torchState, torchState.func_177230_c(), currentPos.func_177967_a(facing.func_176735_f(), 2).func_177981_b(2), originalPos));
                    buildingBlocks.add(Structure.createBuildBlockFromBlockState(torchState, torchState.func_177230_c(), currentPos.func_177967_a(facing.func_176746_e(), 2).func_177981_b(2), originalPos));
                    continue;
                }
                if (!configuration.includeRoof) continue;
                buildingBlocks.add(Structure.createBuildBlockFromBlockState(glassState, glassState.func_177230_c(), currentPos.func_177967_a(facing.func_176735_f(), 2).func_177981_b(2 + j), originalPos));
                buildingBlocks.add(Structure.createBuildBlockFromBlockState(glassState, glassState.func_177230_c(), currentPos.func_177967_a(facing.func_176746_e(), 2).func_177981_b(2 + j), originalPos));
            }
        }
        this.setBlocks(buildingBlocks);
    }

    private void setupClearSpace(InstantBridgeConfiguration configuration) {
        int clearHeight = 3;
        if (configuration.includeRoof) {
            clearHeight = configuration.interiorHeight - clearHeight + clearHeight + 2;
        }
        BuildClear clear = new BuildClear();
        clear.getStartingPosition().setSouthOffset(1);
        clear.getStartingPosition().setEastOffset(2);
        clear.getShape().setDirection(EnumFacing.SOUTH);
        clear.getShape().setHeight(clearHeight - 1);
        clear.getShape().setWidth(5);
        clear.getShape().setLength(configuration.bridgeLength);
        this.setClearSpace(clear);
    }
}

