/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Predefined;

import com.wuest.prefab.Structures.Base.BuildBlock;
import com.wuest.prefab.Structures.Base.BuildClear;
import com.wuest.prefab.Structures.Base.BuildShape;
import com.wuest.prefab.Structures.Base.PositionOffset;
import com.wuest.prefab.Structures.Base.Structure;
import com.wuest.prefab.Structures.Config.BasicStructureConfiguration;
import com.wuest.prefab.Structures.Config.StructureConfiguration;
import com.wuest.prefab.Structures.Predefined.StructureAlternateStart;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class StructureBasic
extends Structure {
    BlockPos customBlockPos = null;

    public static void ScanStructure(World world, BlockPos originalPos, EnumFacing playerFacing, BasicStructureConfiguration configuration, boolean includeAir, boolean excludeWater) {
        BuildClear clearedSpace = new BuildClear();
        clearedSpace.setShape(configuration.basicStructureName.getClearShape());
        clearedSpace.setStartingPosition(configuration.basicStructureName.getClearPositionOffset());
        clearedSpace.getShape().setDirection(playerFacing);
        if (!configuration.IsCustomStructure()) {
            BuildShape buildShape = configuration.basicStructureName.getClearShape().Clone();
            buildShape.setWidth(buildShape.getWidth() - 1);
            buildShape.setLength(buildShape.getLength() - 1);
            PositionOffset offset = configuration.basicStructureName.getClearPositionOffset();
            clearedSpace.getShape().setWidth(clearedSpace.getShape().getWidth());
            clearedSpace.getShape().setLength(clearedSpace.getShape().getLength());
            int downOffset = offset.getHeightOffset() < 0 ? Math.abs(offset.getHeightOffset()) : 0;
            BlockPos cornerPos = originalPos.func_177967_a(playerFacing.func_176735_f(), offset.getOffSetValueForFacing(playerFacing.func_176735_f())).func_177967_a(playerFacing, offset.getOffSetValueForFacing(playerFacing)).func_177979_c(downOffset);
            BlockPos otherCorner = cornerPos.func_177967_a(playerFacing, buildShape.getLength()).func_177967_a(playerFacing.func_176746_e(), buildShape.getWidth()).func_177981_b(buildShape.getHeight());
            Structure.ScanStructure(world, originalPos, cornerPos, otherCorner, "..\\src\\main\\resources\\assets\\prefab\\structures\\" + configuration.basicStructureName.getName() + ".zip", clearedSpace, playerFacing, includeAir, excludeWater);
        }
    }

    @Override
    protected Boolean CustomBlockProcessingHandled(StructureConfiguration configuration, BuildBlock block, World world, BlockPos originalPos, EnumFacing assumedNorth, Block foundBlock, IBlockState blockState, EntityPlayer player) {
        BasicStructureConfiguration config = (BasicStructureConfiguration)configuration;
        if (foundBlock instanceof BlockHopper && config.basicStructureName.getName().equals(BasicStructureConfiguration.EnumBasicStructureName.AdvancedCoop.getName())) {
            this.customBlockPos = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
        } else if (foundBlock instanceof BlockTrapDoor && config.basicStructureName.getName().equals(BasicStructureConfiguration.EnumBasicStructureName.MineshaftEntrance.getName())) {
            this.customBlockPos = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
        }
        return false;
    }

    @Override
    public void AfterBuilding(StructureConfiguration configuration, World world, BlockPos originalPos, EnumFacing assumedNorth, EntityPlayer player) {
        BasicStructureConfiguration config = (BasicStructureConfiguration)configuration;
        if (this.customBlockPos != null) {
            if (config.basicStructureName.getName().equals(BasicStructureConfiguration.EnumBasicStructureName.AdvancedCoop.getName())) {
                for (int i = 0; i < 4; ++i) {
                    EntityChicken entity = new EntityChicken(world);
                    entity.func_70107_b((double)this.customBlockPos.func_177958_n(), (double)this.customBlockPos.func_177984_a().func_177956_o(), (double)this.customBlockPos.func_177952_p());
                    world.func_72838_d((Entity)entity);
                }
            } else if (config.basicStructureName.getName().equals(BasicStructureConfiguration.EnumBasicStructureName.MineshaftEntrance.getName())) {
                StructureAlternateStart.PlaceMineShaft(world, this.customBlockPos.func_177977_b(), configuration.houseFacing, true);
            }
            this.customBlockPos = null;
        }
        if (config.basicStructureName.getName().equals(BasicStructureConfiguration.EnumBasicStructureName.AquaBase.getName())) {
            BlockPos airPos = originalPos.func_177981_b(4).func_177967_a(configuration.houseFacing.func_176734_d(), 1);
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176746_e()));
            world.func_175698_g(airPos);
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176735_f()));
            airPos = airPos.func_177977_b();
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176746_e()));
            world.func_175698_g(airPos);
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176735_f()));
            airPos = airPos.func_177977_b();
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176746_e()));
            world.func_175698_g(airPos);
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176735_f()));
            airPos = airPos.func_177977_b();
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176746_e()));
            world.func_175698_g(airPos);
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176735_f()));
            airPos = airPos.func_177972_a(configuration.houseFacing.func_176734_d()).func_177984_a();
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176746_e()));
            world.func_175698_g(airPos);
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176735_f()));
            airPos = airPos.func_177984_a();
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176746_e()));
            world.func_175698_g(airPos);
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176735_f()));
            airPos = airPos.func_177984_a();
            world.func_175698_g(airPos);
        }
    }
}

