/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Gui;

import com.wuest.prefab.Prefab;
import com.wuest.prefab.Structures.Config.StructureConfiguration;
import com.wuest.prefab.Structures.Messages.StructureTagMessage;
import java.awt.Color;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiStructure
extends GuiScreen {
    public final ResourceLocation backgroundTextures = new ResourceLocation("prefab", "textures/gui/default_background.png");
    public BlockPos pos;
    protected EntityPlayer player;
    protected EnumFacing structureFacing;
    protected GuiButtonExt btnCancel;
    protected GuiButtonExt btnBuild;
    protected GuiButtonExt btnVisualize;
    protected int textColor = Color.DARK_GRAY.getRGB();
    protected StructureTagMessage.EnumStructureConfiguration structureConfiguration;
    protected boolean pauseGame;

    public GuiStructure(int x, int y, int z, boolean pauseGame) {
        this.pos = new BlockPos(x, y, z);
        this.pauseGame = pauseGame;
    }

    public void func_73866_w_() {
        this.player = this.field_146297_k.field_71439_g;
        this.structureFacing = this.player.func_174811_aO().func_176734_d();
        this.Initialize();
    }

    protected void Initialize() {
    }

    protected int getCenteredXAxis() {
        return this.field_146294_l / 2;
    }

    protected int getCenteredYAxis() {
        return this.field_146295_m / 2;
    }

    public boolean func_73868_f() {
        return this.pauseGame;
    }

    protected void drawControlBackgroundAndButtonsAndLabels(int grayBoxX, int grayBoxY, int mouseX, int mouseY) {
        this.field_146297_k.func_110434_K().func_110577_a(this.backgroundTextures);
        this.func_73729_b(grayBoxX, grayBoxY, 0, 0, 256, 256);
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            GuiButton currentButton = (GuiButton)this.field_146292_n.get(i);
            if (currentButton == null || !currentButton.field_146125_m) continue;
            currentButton.func_191745_a(this.field_146297_k, mouseX, mouseY, this.field_146297_k.func_184121_ak());
        }
        for (int j = 0; j < this.field_146293_o.size(); ++j) {
            GuiLabel currentLabel = (GuiLabel)this.field_146293_o.get(j);
            if (currentLabel == null) continue;
            currentLabel.func_146159_a(this.field_146297_k, mouseX, mouseY);
        }
    }

    protected void performCancelOrBuildOrHouseFacing(StructureConfiguration configuration, GuiButton button) throws IOException {
        configuration.houseFacing = this.structureFacing;
        if (button == this.btnCancel) {
            this.field_146297_k.func_147108_a(null);
        } else if (button == this.btnBuild) {
            Prefab.network.sendToServer((IMessage)new StructureTagMessage(configuration.WriteToNBTTagCompound(), this.structureConfiguration));
            this.field_146297_k.func_147108_a(null);
        }
    }

    public void drawModalRectWithCustomSizedTexture(int x, int y, int z, int width, int height, float textureWidth, float textureHeight) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        float u = 0.0f;
        float v = 0.0f;
        float f = 1.0f / textureWidth;
        float f1 = 1.0f / textureHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b((double)x, (double)(y + height), (double)z).func_187315_a((double)(u * f), (double)((v + (float)height) * f1)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + height), (double)z).func_187315_a((double)((u + (float)width) * f), (double)((v + (float)height) * f1)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)y, (double)z).func_187315_a((double)((u + (float)width) * f), (double)(v * f1)).func_181675_d();
        vertexbuffer.func_181662_b((double)x, (double)y, (double)z).func_187315_a((double)(u * f), (double)(v * f1)).func_181675_d();
        tessellator.func_78381_a();
    }
}

