/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Gui;

import com.wuest.prefab.Config.ModConfiguration;
import com.wuest.prefab.Events.ClientEventHandler;
import com.wuest.prefab.Gui.Controls.GuiCheckBox;
import com.wuest.prefab.Gui.Controls.GuiTab;
import com.wuest.prefab.Gui.Controls.GuiTextSlider;
import com.wuest.prefab.Gui.GuiLangKeys;
import com.wuest.prefab.Gui.GuiTabScreen;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.Proxy.ClientProxy;
import com.wuest.prefab.Proxy.CommonProxy;
import com.wuest.prefab.Structures.Config.HouseConfiguration;
import com.wuest.prefab.Structures.Messages.StructureTagMessage;
import com.wuest.prefab.Structures.Predefined.StructureAlternateStart;
import com.wuest.prefab.Structures.Render.StructureRenderHandler;
import java.awt.Color;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiSlider;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiStartHouseChooser
extends GuiTabScreen {
    private static final ResourceLocation backgroundTextures = new ResourceLocation("prefab", "textures/gui/default_background.png");
    protected GuiButtonExt btnCancel;
    protected GuiButtonExt btnBuild;
    protected GuiTab tabGeneral;
    protected GuiTab tabConfig;
    protected GuiTab tabBlockTypes;
    protected GuiButtonExt btnHouseStyle;
    protected GuiButtonExt btnGlassColor;
    protected GuiButtonExt btnVisualize;
    protected GuiCheckBox btnAddTorches;
    protected GuiCheckBox btnAddBed;
    protected GuiCheckBox btnAddCraftingTable;
    protected GuiCheckBox btnAddFurnace;
    protected GuiCheckBox btnAddChest;
    protected GuiCheckBox btnAddChestContents;
    protected GuiCheckBox btnAddFarm;
    protected GuiCheckBox btnAddMineShaft;
    protected GuiCheckBox btnIsCeilingFlat;
    protected GuiSlider btnHouseWidth;
    protected GuiSlider btnHouseDepth;
    protected GuiTextSlider btnFloorBlock;
    protected GuiTextSlider btnCeilingBlock;
    protected GuiTextSlider btnWallWoodType;
    protected HouseConfiguration houseConfiguration = ClientEventHandler.playerConfig.getClientConfig("Starter House", HouseConfiguration.class);
    protected ModConfiguration serverConfiguration;
    protected boolean allowItemsInChestAndFurnace = true;

    public GuiStartHouseChooser(int x, int y, int z) {
        this.houseConfiguration.pos = new BlockPos(x, y, z);
        this.Tabs.trayWidth = 256;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (!Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d) {
            this.allowItemsInChestAndFurnace = !ClientEventHandler.playerConfig.builtStarterHouse;
        }
        this.Initialize();
    }

    @Override
    public void func_73863_a(int x, int y, float f) {
        int grayBoxX = this.field_146294_l / 2 - 188;
        int grayBoxY = this.field_146295_m / 2 - 83;
        this.Tabs.trayX = grayBoxX;
        this.Tabs.trayY = grayBoxY - 21;
        this.func_146276_q_();
        this.field_146297_k.func_110434_K().func_110577_a(backgroundTextures);
        this.func_73729_b(grayBoxX, grayBoxY, 0, 0, 256, 256);
        for (GuiButton button : this.field_146292_n) {
            if (button == this.btnCancel || button == this.btnBuild) continue;
            button.field_146125_m = false;
        }
        this.btnAddTorches.field_146125_m = false;
        this.btnAddBed.field_146125_m = false;
        this.btnAddChest.field_146125_m = false;
        this.btnAddChestContents.field_146125_m = false;
        this.btnAddCraftingTable.field_146125_m = false;
        this.btnAddFurnace.field_146125_m = false;
        this.btnAddFarm.field_146125_m = false;
        this.btnAddMineShaft.field_146125_m = false;
        this.btnIsCeilingFlat.field_146125_m = false;
        if (this.getSelectedTab() == this.tabGeneral) {
            this.btnHouseStyle.field_146125_m = true;
            this.btnVisualize.field_146125_m = this.houseConfiguration.houseStyle != HouseConfiguration.HouseStyle.BASIC;
        } else if (this.getSelectedTab() == this.tabConfig) {
            this.btnAddTorches.field_146125_m = this.serverConfiguration.addTorches;
            this.btnAddBed.field_146125_m = this.serverConfiguration.addBed;
            this.btnAddChest.field_146125_m = this.serverConfiguration.addChests;
            this.btnAddChestContents.field_146125_m = this.allowItemsInChestAndFurnace && this.serverConfiguration.addChestContents;
            this.btnAddCraftingTable.field_146125_m = this.serverConfiguration.addCraftingTable;
            this.btnAddFurnace.field_146125_m = this.serverConfiguration.addFurnace;
            this.btnAddMineShaft.field_146125_m = this.serverConfiguration.addMineshaft;
            if (this.houseConfiguration.houseStyle == HouseConfiguration.HouseStyle.BASIC) {
                this.btnAddFarm.field_146125_m = this.serverConfiguration.addFarm;
                this.btnIsCeilingFlat.field_146125_m = true;
            }
        } else if (this.getSelectedTab() == this.tabBlockTypes) {
            if (this.houseConfiguration.houseStyle == HouseConfiguration.HouseStyle.BASIC) {
                this.btnFloorBlock.field_146125_m = true;
                this.btnWallWoodType.field_146125_m = true;
                this.btnCeilingBlock.field_146125_m = true;
                this.btnHouseDepth.field_146125_m = true;
                this.btnHouseWidth.field_146125_m = true;
            } else {
                this.btnGlassColor.field_146125_m = this.houseConfiguration.houseStyle != HouseConfiguration.HouseStyle.SNOWY && this.houseConfiguration.houseStyle != HouseConfiguration.HouseStyle.DESERT;
            }
        }
        super.func_73863_a(x, y, f);
        int color = Color.DARK_GRAY.getRGB();
        if (this.getSelectedTab() == this.tabGeneral) {
            this.field_146297_k.field_71466_p.func_78276_b(GuiLangKeys.translateString("prefab.gui.starter.style.label"), grayBoxX + 10, grayBoxY + 10, color);
            this.field_146297_k.field_71466_p.func_78279_b(this.houseConfiguration.houseStyle.getHouseNotes(), grayBoxX + 147, grayBoxY + 10, 95, color);
            this.field_146297_k.func_110434_K().func_110577_a(this.houseConfiguration.houseStyle.getHousePicture());
            GuiTabScreen.drawModalRectWithCustomSizedTexture(grayBoxX + 250, grayBoxY, 1, this.houseConfiguration.houseStyle.getImageWidth(), this.houseConfiguration.houseStyle.getImageHeight(), this.houseConfiguration.houseStyle.getImageWidth(), this.houseConfiguration.houseStyle.getImageHeight());
        } else if (this.getSelectedTab() == this.tabBlockTypes) {
            if (this.houseConfiguration.houseStyle == HouseConfiguration.HouseStyle.BASIC) {
                this.field_146297_k.field_71466_p.func_78276_b(GuiLangKeys.translateString("prefab.gui.starter.floortype.label"), grayBoxX + 10, grayBoxY + 10, color);
                this.field_146297_k.field_71466_p.func_78276_b(GuiLangKeys.translateString("prefab.gui.starter.ceilingtype.label"), grayBoxX + 10, grayBoxY + 50, color);
                this.field_146297_k.field_71466_p.func_78276_b(GuiLangKeys.translateString("prefab.gui.starter.walltype.label"), grayBoxX + 10, grayBoxY + 90, color);
                this.field_146297_k.field_71466_p.func_78276_b(GuiLangKeys.translateString("prefab.gui.starter.depth.label"), grayBoxX + 147, grayBoxY + 10, color);
                this.field_146297_k.field_71466_p.func_78276_b(GuiLangKeys.translateString("prefab.gui.starter.width.label"), grayBoxX + 147, grayBoxY + 50, color);
            } else if (this.houseConfiguration.houseStyle != HouseConfiguration.HouseStyle.SNOWY && this.houseConfiguration.houseStyle != HouseConfiguration.HouseStyle.DESERT) {
                this.field_146297_k.field_71466_p.func_78276_b(GuiLangKeys.translateString("prefab.gui.structure.glass"), grayBoxX + 10, grayBoxY + 10, color);
            }
        }
        if (!CommonProxy.proxyConfiguration.enableStructurePreview) {
            this.btnVisualize.field_146124_l = false;
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button == this.btnCancel || button == this.btnVisualize || button == this.btnBuild) {
            this.houseConfiguration.addBed = this.serverConfiguration.addBed && this.btnAddBed.isChecked();
            boolean bl = this.houseConfiguration.addChest = this.serverConfiguration.addChests && this.btnAddChest.isChecked();
            this.houseConfiguration.addChestContents = this.allowItemsInChestAndFurnace ? this.serverConfiguration.addChestContents && this.btnAddChestContents.isChecked() : false;
            this.houseConfiguration.addCraftingTable = this.serverConfiguration.addCraftingTable && this.btnAddCraftingTable.isChecked();
            this.houseConfiguration.addFurnace = this.serverConfiguration.addFurnace && this.btnAddFurnace.isChecked();
            this.houseConfiguration.addFarm = this.serverConfiguration.addFarm && this.btnAddFarm.isChecked();
            this.houseConfiguration.addMineShaft = this.serverConfiguration.addMineshaft && this.btnAddMineShaft.isChecked();
            this.houseConfiguration.addTorches = this.serverConfiguration.addTorches && this.btnAddTorches.isChecked();
            this.houseConfiguration.isCeilingFlat = this.btnIsCeilingFlat.isChecked();
            this.houseConfiguration.ceilingBlock = ModConfiguration.CeilingFloorBlockType.ValueOf(this.btnCeilingBlock.getValueInt());
            this.houseConfiguration.floorBlock = ModConfiguration.CeilingFloorBlockType.ValueOf(this.btnFloorBlock.getValueInt());
            this.houseConfiguration.wallWoodType = ModConfiguration.WallBlockType.ValueOf(this.btnWallWoodType.getValueInt());
            this.houseConfiguration.houseDepth = this.btnHouseDepth.getValueInt();
            this.houseConfiguration.houseWidth = this.btnHouseWidth.getValueInt();
            this.houseConfiguration.houseStyle = this.houseConfiguration.houseStyle;
            this.houseConfiguration.houseFacing = this.field_146297_k.field_71439_g.func_174811_aO().func_176734_d();
        }
        if (button == this.btnCancel) {
            this.field_146297_k.func_147108_a(null);
        } else if (button == this.btnBuild) {
            Prefab.network.sendToServer((IMessage)new StructureTagMessage(this.houseConfiguration.WriteToNBTTagCompound(), StructureTagMessage.EnumStructureConfiguration.StartHouse));
            this.field_146297_k.func_147108_a(null);
        } else if (button == this.btnHouseStyle) {
            int id = this.houseConfiguration.houseStyle.getValue() + 1;
            this.houseConfiguration.houseStyle = HouseConfiguration.HouseStyle.ValueOf(id);
            if (this.houseConfiguration.houseStyle == HouseConfiguration.HouseStyle.LOFT && !this.serverConfiguration.enableLoftHouse) {
                id = this.houseConfiguration.houseStyle.getValue() + 1;
                this.houseConfiguration.houseStyle = HouseConfiguration.HouseStyle.ValueOf(id);
            }
            this.btnHouseStyle.field_146126_j = this.houseConfiguration.houseStyle.getDisplayName();
            if (this.houseConfiguration.houseStyle == HouseConfiguration.HouseStyle.HOBBIT) {
                this.houseConfiguration.glassColor = EnumDyeColor.GREEN;
                this.btnGlassColor.field_146126_j = GuiLangKeys.translateDye(EnumDyeColor.GREEN);
            } else if (this.houseConfiguration.houseStyle == HouseConfiguration.HouseStyle.LOFT) {
                this.houseConfiguration.glassColor = EnumDyeColor.BLACK;
                this.btnGlassColor.field_146126_j = GuiLangKeys.translateDye(EnumDyeColor.BLACK);
            } else {
                this.houseConfiguration.glassColor = EnumDyeColor.CYAN;
                this.btnGlassColor.field_146126_j = GuiLangKeys.translateDye(EnumDyeColor.CYAN);
            }
            this.tabBlockTypes.visible = this.houseConfiguration.houseStyle != HouseConfiguration.HouseStyle.DESERT && this.houseConfiguration.houseStyle != HouseConfiguration.HouseStyle.SNOWY;
        } else if (button == this.btnGlassColor) {
            this.houseConfiguration.glassColor = EnumDyeColor.func_176764_b((int)(this.houseConfiguration.glassColor.func_176765_a() + 1));
            this.btnGlassColor.field_146126_j = GuiLangKeys.translateDye(this.houseConfiguration.glassColor);
        } else if (button == this.btnVisualize) {
            StructureAlternateStart structure = (StructureAlternateStart)StructureAlternateStart.CreateInstance(this.houseConfiguration.houseStyle.getStructureLocation(), StructureAlternateStart.class);
            StructureRenderHandler.setStructure(structure, EnumFacing.NORTH, this.houseConfiguration);
            this.field_146297_k.func_147108_a(null);
        }
    }

    public boolean func_73868_f() {
        return true;
    }

    private void Initialize() {
        int y;
        int grayBoxX = this.field_146294_l / 2 - 188;
        int grayBoxY = this.field_146295_m / 2 - 83;
        int color = Color.DARK_GRAY.getRGB();
        this.serverConfiguration = ((ClientProxy)Prefab.proxy).getServerConfiguration();
        this.btnHouseStyle = new GuiButtonExt(4, grayBoxX + 10, grayBoxY + 20, 90, 20, this.houseConfiguration.houseStyle.getDisplayName());
        this.field_146292_n.add(this.btnHouseStyle);
        this.btnVisualize = new GuiButtonExt(4, grayBoxX + 10, grayBoxY + 60, 90, 20, GuiLangKeys.translateString("prefab.gui.button.preview"));
        this.field_146292_n.add(this.btnVisualize);
        int x = grayBoxX + 10;
        int secondColumnY = y = grayBoxY + 10;
        int secondColumnX = x + 137;
        this.btnAddFurnace = new GuiCheckBox(5, secondColumnX, secondColumnY, GuiLangKeys.translateString("prefab.gui.starter.addfurnace"), this.houseConfiguration.addFurnace);
        this.btnAddFurnace.setStringColor(color);
        this.btnAddFurnace.setWithShadow(false);
        this.btnAddFurnace.field_146125_m = false;
        this.field_146292_n.add(this.btnAddFurnace);
        if (this.serverConfiguration.addFurnace) {
            secondColumnY += 15;
        }
        this.btnAddBed = new GuiCheckBox(2, secondColumnX, secondColumnY, GuiLangKeys.translateString("prefab.gui.starter.addbed"), this.houseConfiguration.addBed);
        this.btnAddBed.setStringColor(color);
        this.btnAddBed.setWithShadow(false);
        this.btnAddBed.field_146125_m = false;
        this.field_146292_n.add(this.btnAddBed);
        if (this.serverConfiguration.addBed) {
            secondColumnY += 15;
        }
        this.btnAddFarm = new GuiCheckBox(6, secondColumnX, secondColumnY, GuiLangKeys.translateString("prefab.gui.starter.addfarm"), this.houseConfiguration.addFarm);
        this.btnAddFarm.setStringColor(color);
        this.btnAddFarm.setWithShadow(false);
        this.btnAddFarm.field_146125_m = false;
        this.field_146292_n.add(this.btnAddFarm);
        if (this.serverConfiguration.addFarm) {
            secondColumnY += 15;
        }
        this.btnAddCraftingTable = new GuiCheckBox(5, x, y, GuiLangKeys.translateString("prefab.gui.starter.addcraftingtable"), this.houseConfiguration.addCraftingTable);
        this.btnAddCraftingTable.setStringColor(color);
        this.btnAddCraftingTable.setWithShadow(false);
        this.btnAddCraftingTable.field_146125_m = false;
        this.field_146292_n.add(this.btnAddCraftingTable);
        if (this.serverConfiguration.addCraftingTable) {
            y += 15;
        }
        this.btnAddTorches = new GuiCheckBox(1, x, y, GuiLangKeys.translateString("prefab.gui.starter.addtorches"), this.houseConfiguration.addTorches);
        this.btnAddTorches.setStringColor(color);
        this.btnAddTorches.setWithShadow(false);
        this.btnAddTorches.field_146125_m = false;
        this.field_146292_n.add(this.btnAddTorches);
        if (this.serverConfiguration.addTorches) {
            y += 15;
        }
        this.btnAddChest = new GuiCheckBox(3, x, y, GuiLangKeys.translateString("prefab.gui.starter.addchest"), this.houseConfiguration.addChest);
        this.btnAddChest.setStringColor(color);
        this.btnAddChest.setWithShadow(false);
        this.btnAddChest.field_146125_m = false;
        this.field_146292_n.add(this.btnAddChest);
        if (this.serverConfiguration.addChests) {
            y += 15;
        }
        this.btnAddMineShaft = new GuiCheckBox(7, x, y, GuiLangKeys.translateString("prefab.gui.starter.buildmineshaft"), this.houseConfiguration.addMineShaft);
        this.btnAddMineShaft.setStringColor(color);
        this.btnAddMineShaft.setWithShadow(false);
        this.btnAddMineShaft.field_146125_m = false;
        this.field_146292_n.add(this.btnAddMineShaft);
        if (this.serverConfiguration.addMineshaft) {
            y += 15;
        }
        this.btnAddChestContents = new GuiCheckBox(4, x, y, GuiLangKeys.translateString("prefab.gui.starter.addchestcontents"), this.houseConfiguration.addChestContents);
        this.btnAddChestContents.setStringColor(color);
        this.btnAddChestContents.setWithShadow(false);
        this.btnAddChestContents.field_146125_m = false;
        this.field_146292_n.add(this.btnAddChestContents);
        if (this.allowItemsInChestAndFurnace) {
            y += 15;
        }
        this.btnIsCeilingFlat = new GuiCheckBox(8, x, y, GuiLangKeys.translateString("prefab.gui.starter.ceilingflat"), this.houseConfiguration.isCeilingFlat);
        this.btnIsCeilingFlat.setStringColor(color);
        this.btnIsCeilingFlat.setWithShadow(false);
        this.btnIsCeilingFlat.field_146125_m = false;
        this.field_146292_n.add(this.btnIsCeilingFlat);
        this.btnFloorBlock = new GuiTextSlider(11, grayBoxX + 10, grayBoxY + 20, 90, 20, 0.0, 2.0, this.houseConfiguration.floorBlock.getValue(), "prefab.gui.starter.floorstone");
        this.field_146292_n.add(this.btnFloorBlock);
        this.btnCeilingBlock = new GuiTextSlider(12, grayBoxX + 10, grayBoxY + 60, 90, 20, 0.0, 2.0, this.houseConfiguration.ceilingBlock.getValue(), "prefab.gui.starter.ceilingtype");
        this.field_146292_n.add(this.btnCeilingBlock);
        this.btnWallWoodType = new GuiTextSlider(13, grayBoxX + 10, grayBoxY + 100, 90, 20, 0.0, 5.0, this.houseConfiguration.wallWoodType.getValue(), "prefab.gui.starter.walltype");
        this.field_146292_n.add(this.btnWallWoodType);
        this.btnGlassColor = new GuiButtonExt(17, grayBoxX + 10, grayBoxY + 20, 90, 20, GuiLangKeys.translateDye(this.houseConfiguration.glassColor));
        this.field_146292_n.add(this.btnGlassColor);
        this.btnHouseDepth = new GuiSlider(15, grayBoxX + 147, grayBoxY + 20, 90, 20, "", "", 5.0, (double)this.serverConfiguration.maximumStartingHouseSize, (double)this.houseConfiguration.houseDepth, false, true);
        this.field_146292_n.add(this.btnHouseDepth);
        this.btnHouseWidth = new GuiSlider(16, grayBoxX + 147, grayBoxY + 60, 90, 20, "", "", 5.0, (double)this.serverConfiguration.maximumStartingHouseSize, (double)this.houseConfiguration.houseWidth, false, true);
        this.field_146292_n.add(this.btnHouseWidth);
        this.tabGeneral = new GuiTab(this.Tabs, GuiLangKeys.translateString("prefab.gui.starter.tab.general"), grayBoxX + 3, grayBoxY - 20);
        this.Tabs.AddTab(this.tabGeneral);
        this.tabConfig = new GuiTab(this.Tabs, GuiLangKeys.translateString("prefab.gui.starter.tab.config"), grayBoxX + 54, grayBoxY - 20);
        this.Tabs.AddTab(this.tabConfig);
        this.tabBlockTypes = new GuiTab(this.Tabs, GuiLangKeys.translateString("prefab.gui.starter.tab.block"), grayBoxX + 105, grayBoxY - 20);
        this.tabBlockTypes.width = 70;
        this.Tabs.AddTab(this.tabBlockTypes);
        this.btnBuild = new GuiButtonExt(1, grayBoxX + 10, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.build"));
        this.field_146292_n.add(this.btnBuild);
        this.btnCancel = new GuiButtonExt(2, grayBoxX + 147, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.cancel"));
        this.field_146292_n.add(this.btnCancel);
    }
}

