/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Gui;

import com.wuest.prefab.Events.ClientEventHandler;
import com.wuest.prefab.Gui.GuiLangKeys;
import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Proxy.CommonProxy;
import com.wuest.prefab.Structures.Capabilities.IStructureConfigurationCapability;
import com.wuest.prefab.Structures.Config.BasicStructureConfiguration;
import com.wuest.prefab.Structures.Gui.GuiStructure;
import com.wuest.prefab.Structures.Items.ItemBasicStructure;
import com.wuest.prefab.Structures.Messages.StructureTagMessage;
import com.wuest.prefab.Structures.Predefined.StructureBasic;
import com.wuest.prefab.Structures.Render.StructureRenderHandler;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.client.config.GuiButtonExt;

public class GuiBasicStructure
extends GuiStructure {
    protected BasicStructureConfiguration configuration;
    protected boolean includePicture = true;
    protected int modifiedInitialXAxis = 213;
    protected int modifiedINitialYAxis = 83;

    public GuiBasicStructure(int x, int y, int z) {
        super(x, y, z, true);
        this.structureConfiguration = StructureTagMessage.EnumStructureConfiguration.Basic;
    }

    public void func_73863_a(int x, int y, float f) {
        int grayBoxX = this.getCenteredXAxis() - this.modifiedInitialXAxis;
        int grayBoxY = this.getCenteredYAxis() - this.modifiedINitialYAxis;
        this.func_146276_q_();
        if (this.includePicture) {
            this.field_146297_k.func_110434_K().func_110577_a(this.configuration.basicStructureName.getTopDownPictureLocation());
            this.drawModalRectWithCustomSizedTexture(grayBoxX + 250, grayBoxY, 1, this.configuration.basicStructureName.getImageWidth(), this.configuration.basicStructureName.getImageHeight(), this.configuration.basicStructureName.getImageWidth(), this.configuration.basicStructureName.getImageHeight());
        }
        this.drawControlBackgroundAndButtonsAndLabels(grayBoxX, grayBoxY, x, y);
        this.field_146297_k.field_71466_p.func_78279_b(GuiLangKeys.translateString("prefab.gui.structure.block.clicked"), grayBoxX + 147, grayBoxY + 10, 95, this.textColor);
        if (!CommonProxy.proxyConfiguration.enableStructurePreview) {
            this.btnVisualize.field_146124_l = false;
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        this.performCancelOrBuildOrHouseFacing(this.configuration, button);
        if (button == this.btnVisualize) {
            StructureBasic structure = (StructureBasic)StructureBasic.CreateInstance(this.configuration.basicStructureName.getAssetLocation(), StructureBasic.class);
            StructureRenderHandler.setStructure(structure, EnumFacing.NORTH, this.configuration);
            this.field_146297_k.func_147108_a(null);
        }
    }

    @Override
    protected void Initialize() {
        ItemStack stack = ItemBasicStructure.getBasicStructureItemInHand(this.player);
        if (stack != null) {
            IStructureConfigurationCapability capability = (IStructureConfigurationCapability)stack.getCapability(ModRegistry.StructureConfiguration, EnumFacing.NORTH);
            this.configuration = capability.getConfiguration();
            if (!ClientEventHandler.playerConfig.clientConfigurations.containsKey(this.configuration.basicStructureName.getName())) {
                ClientEventHandler.playerConfig.clientConfigurations.put(this.configuration.basicStructureName.getName(), this.configuration);
            } else {
                this.configuration = ClientEventHandler.playerConfig.getClientConfig(this.configuration.basicStructureName.getName(), BasicStructureConfiguration.class);
            }
            this.includePicture = this.doesPictureExist();
        }
        this.configuration.pos = this.pos;
        if (!this.includePicture) {
            this.modifiedInitialXAxis = 125;
        }
        int grayBoxX = this.getCenteredXAxis() - this.modifiedInitialXAxis;
        int grayBoxY = this.getCenteredYAxis() - this.modifiedINitialYAxis;
        this.btnVisualize = new GuiButtonExt(4, grayBoxX + 10, grayBoxY + 20, 90, 20, GuiLangKeys.translateString("prefab.gui.button.preview"));
        this.field_146292_n.add(this.btnVisualize);
        this.btnBuild = new GuiButtonExt(1, grayBoxX + 10, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.build"));
        this.field_146292_n.add(this.btnBuild);
        this.btnCancel = new GuiButtonExt(2, grayBoxX + 147, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.cancel"));
        this.field_146292_n.add(this.btnCancel);
    }

    protected boolean doesPictureExist() {
        try {
            this.field_146297_k.func_110442_L().func_110536_a(this.configuration.basicStructureName.getTopDownPictureLocation());
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

