/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Gui;

import com.wuest.prefab.Config.DrafterTileEntityConfig;
import com.wuest.prefab.Config.ModConfiguration;
import com.wuest.prefab.Gui.Controls.GuiRoomInfoButton;
import com.wuest.prefab.Gui.Controls.GuiTab;
import com.wuest.prefab.Gui.GuiLangKeys;
import com.wuest.prefab.Gui.GuiTabScreen;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.Proxy.ClientProxy;
import com.wuest.prefab.TileEntities.TileEntityDrafter;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.GuiScrollingList;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.HoverChecker;

public class GuiDrafter
extends GuiTabScreen {
    public DrafterTileEntityConfig.AvailableRoomType selectedRoomType;
    private static final ResourceLocation backgroundTextures = new ResourceLocation("prefab", "textures/gui/default_background.png");
    protected GuiTab tabGeneral;
    protected GuiTab tabDesignRoom;
    protected GuiTab tabPendingChanges;
    protected GuiButtonExt btnCancel;
    protected GuiButtonExt btnBuild;
    protected GuiButtonExt btnClearPending;
    protected GuiButtonExt btnAddToPending;
    protected GuiButtonExt btnBasement2;
    protected GuiButtonExt btnBasement1;
    protected GuiButtonExt btnGroundFloor;
    protected GuiButtonExt btnSecondFloor;
    protected GuiButtonExt btnThirdFloor;
    protected RoomList listRooms;
    protected RoomMaterials roomMaterials;
    protected ArrayList<GuiRoomInfoButton> roomButtons;
    protected ArrayList<HoverChecker> roomHovers;
    protected BlockPos pos;
    protected ModConfiguration serverConfiguration;
    protected DrafterTileEntityConfig drafterConfig;
    protected TileEntityDrafter tileEntity;
    protected GuiRoomInfoButton selectedRoom;

    public GuiDrafter(int x, int y, int z) {
        this.pos = new BlockPos(x, y, z);
        this.Tabs.trayWidth = 320;
        this.roomButtons = new ArrayList();
        this.roomHovers = new ArrayList();
        this.selectedRoomType = DrafterTileEntityConfig.AvailableRoomType.Field;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.Initialize();
    }

    public boolean func_73868_f() {
        return true;
    }

    @Override
    public void func_73863_a(int x, int y, float f) {
        int grayBoxX = this.field_146294_l / 2 - 158;
        int grayBoxY = this.field_146295_m / 2 - 93;
        this.Tabs.trayX = grayBoxX;
        this.Tabs.trayY = grayBoxY - 21;
        this.func_146276_q_();
        this.field_146297_k.func_110434_K().func_110577_a(backgroundTextures);
        GuiDrafter.drawModalRectWithCustomSizedTexture(grayBoxX, grayBoxY, 0, 320, 320, 320.0f, 320.0f);
        for (GuiButton button : this.field_146292_n) {
            if (button == this.btnCancel) continue;
            button.field_146125_m = false;
        }
        if (this.getSelectedTab() == this.tabGeneral) {
            this.makeGeneralTabControlsVisible();
        } else if (this.getSelectedTab() == this.tabDesignRoom) {
            this.makeDesignRoomTabControlsVisible(x, y, f);
        } else if (this.getSelectedTab() == this.tabPendingChanges) {
            this.makePendingChangesTabControlsVisible(x, y, f);
        }
        super.func_73863_a(x, y, f);
        for (int i = 0; i < 49; ++i) {
            HoverChecker hoverChecker = this.roomHovers.get(i);
            if (!hoverChecker.checkHover(x, y)) continue;
            GuiRoomInfoButton button = this.roomButtons.get(i);
            if (!button.field_146124_l) continue;
            String hoverText = "";
            hoverText = button.roomInfo.StructureName.getName().equals(DrafterTileEntityConfig.AvailableRoomType.Empty.getName()) ? "\nRoom Coordinates:\n X: BlahX Y: BlahY Z: BlahZ" : "Room Name: " + (i + 1) + "\nRoom Coordinates:\n X: BlahX Y: BlahY Z: BlahZ";
            this.func_146283_a(this.field_146297_k.field_71466_p.func_78271_c(button.getHoverText(), 300), x, y);
        }
        int color = Color.DARK_GRAY.getRGB();
        if (this.getSelectedTab() == this.tabGeneral) {
            this.field_146297_k.field_71466_p.func_78276_b("Level", grayBoxX + 7, grayBoxY + 20, color);
            if (this.selectedRoom != null && !this.selectedRoom.roomInfo.StructureName.getName().equals(DrafterTileEntityConfig.AvailableRoomType.Empty.getName())) {
                // empty if block
            }
        } else if (this.getSelectedTab() == this.tabDesignRoom) {
            this.field_146297_k.field_71466_p.func_78276_b("Available Room Styles", grayBoxX + 7, grayBoxY + 5, color);
            this.field_146297_k.field_71466_p.func_78276_b("Room Materials", grayBoxX + 125, grayBoxY + 5, color);
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button instanceof GuiRoomInfoButton && this.selectedRoom != null) {
            this.selectedRoom.selected = false;
        }
        this.selectedRoom = null;
        if (button == this.btnCancel) {
            this.sendConfigToServer();
            this.field_146297_k.func_147108_a(null);
        } else if (button == this.btnBasement2) {
            this.setRoomInfosForFloor(-2);
            this.setFloorButtonsEnabled();
            this.tabDesignRoom.visible = false;
            button.field_146124_l = false;
        } else if (button == this.btnBasement1) {
            this.setRoomInfosForFloor(-1);
            this.setFloorButtonsEnabled();
            this.tabDesignRoom.visible = false;
            button.field_146124_l = false;
        } else if (button == this.btnGroundFloor) {
            this.setRoomInfosForFloor(0);
            this.setFloorButtonsEnabled();
            this.tabDesignRoom.visible = false;
            button.field_146124_l = false;
        } else if (button == this.btnSecondFloor) {
            this.setRoomInfosForFloor(1);
            this.setFloorButtonsEnabled();
            this.tabDesignRoom.visible = false;
            button.field_146124_l = false;
        } else if (button == this.btnThirdFloor) {
            this.setRoomInfosForFloor(2);
            this.setFloorButtonsEnabled();
            this.tabDesignRoom.visible = false;
            button.field_146124_l = false;
        } else if (button == this.btnClearPending) {
            this.tabPendingChanges.visible = false;
        } else if (button instanceof GuiRoomInfoButton) {
            this.selectedRoom = (GuiRoomInfoButton)button;
            this.selectedRoom.selected = true;
            this.tabDesignRoom.visible = this.selectedRoom.roomInfo.StructureName.getName().equals(DrafterTileEntityConfig.AvailableRoomType.Empty.getName());
        } else if (button == this.btnAddToPending) {
            this.tabPendingChanges.visible = true;
        }
    }

    protected void setRoomInfosForFloor(int floorNumber) {
        DrafterTileEntityConfig.RoomInfo[] roomArray = null;
        switch (floorNumber) {
            case -2: {
                roomArray = this.drafterConfig.Basement2FloorRooms;
                break;
            }
            case -1: {
                roomArray = this.drafterConfig.BasementFloorRooms;
                break;
            }
            case 0: {
                roomArray = this.drafterConfig.FirstFloorRooms;
                break;
            }
            case 1: {
                roomArray = this.drafterConfig.SecondFloorRooms;
                break;
            }
            case 2: {
                roomArray = this.drafterConfig.ThirdFloorRooms;
            }
        }
        this.enableRoomsForFloor(roomArray, floorNumber);
    }

    protected void enableRoomsForFloor(DrafterTileEntityConfig.RoomInfo[] roomArray, int floorNumber) {
        for (int i = 0; i < 49; ++i) {
            GuiRoomInfoButton button = this.roomButtons.get(i);
            button.roomInfo = roomArray[i];
            button.selected = false;
            if (i == 45 && floorNumber == 0) {
                button.field_146124_l = true;
                continue;
            }
            if (i == 45) {
                button.field_146124_l = true;
                continue;
            }
            button.field_146124_l = button.roomInfo.checkNeighbors(roomArray);
            if (button.field_146124_l && button.roomInfo.StructureName.getName().equals(DrafterTileEntityConfig.AvailableRoomType.Empty.getName())) {
                button.field_146126_j = "+";
                continue;
            }
            if (button.field_146124_l) continue;
            button.field_146126_j = "";
        }
    }

    protected void setFloorButtonsEnabled() {
        this.btnBasement2.field_146124_l = true;
        this.btnBasement1.field_146124_l = true;
        this.btnGroundFloor.field_146124_l = true;
        this.btnSecondFloor.field_146124_l = true;
        this.btnThirdFloor.field_146124_l = true;
    }

    private void Initialize() {
        int grayBoxX = this.field_146294_l / 2 - 158;
        int grayBoxY = this.field_146295_m / 2 - 103;
        int color = Color.DARK_GRAY.getRGB();
        int uiComponentID = 1;
        this.serverConfiguration = ((ClientProxy)Prefab.proxy).getServerConfiguration();
        TileEntity entity = this.field_146297_k.field_71441_e.func_175625_s(this.pos);
        if (entity != null && entity.getClass() == TileEntityDrafter.class) {
            this.drafterConfig = (DrafterTileEntityConfig)((TileEntityDrafter)entity).getConfig();
            this.tileEntity = (TileEntityDrafter)entity;
        } else {
            this.tileEntity = new TileEntityDrafter();
            this.field_146297_k.field_71441_e.func_175690_a(this.pos, (TileEntity)this.tileEntity);
            this.drafterConfig = (DrafterTileEntityConfig)this.tileEntity.getConfig();
        }
        this.drafterConfig.pos = this.pos;
        uiComponentID = this.createGeneralTabControls(grayBoxX, grayBoxY, uiComponentID);
        uiComponentID = this.createDesignRoomTabControls(grayBoxX, grayBoxY, uiComponentID);
        uiComponentID = this.createPendingChangesTabControls(grayBoxX, grayBoxY, uiComponentID);
        this.tabGeneral.setIsSelected(true);
    }

    private int createGeneralTabControls(int grayBoxX, int grayBoxY, int uiComponentID) {
        int roomX = grayBoxX + 40;
        int roomY = grayBoxY + 30;
        for (int i = 1; i < 50; ++i) {
            GuiRoomInfoButton roomButton = new GuiRoomInfoButton(uiComponentID++, roomX, roomY, 18, 18, "");
            HoverChecker hoverChecker = new HoverChecker((GuiButton)roomButton, 800);
            this.roomHovers.add(hoverChecker);
            this.field_146292_n.add(roomButton);
            this.roomButtons.add(roomButton);
            roomX += 18;
            if (i % 7 != 0) continue;
            roomX = grayBoxX + 40;
            roomY += 18;
        }
        this.btnBasement2 = new GuiButtonExt(uiComponentID++, grayBoxX + 10, grayBoxY + 145, 20, 20, "B2");
        this.field_146292_n.add(this.btnBasement2);
        this.btnBasement1 = new GuiButtonExt(uiComponentID++, grayBoxX + 10, grayBoxY + 120, 20, 20, "B1");
        this.field_146292_n.add(this.btnBasement1);
        this.btnGroundFloor = new GuiButtonExt(uiComponentID++, grayBoxX + 10, grayBoxY + 95, 20, 20, "G");
        this.btnGroundFloor.field_146124_l = false;
        this.field_146292_n.add(this.btnGroundFloor);
        this.btnSecondFloor = new GuiButtonExt(uiComponentID++, grayBoxX + 10, grayBoxY + 70, 20, 20, "2");
        this.field_146292_n.add(this.btnSecondFloor);
        this.btnThirdFloor = new GuiButtonExt(uiComponentID++, grayBoxX + 10, grayBoxY + 45, 20, 20, "3");
        this.field_146292_n.add(this.btnThirdFloor);
        this.btnClearPending = new GuiButtonExt(uiComponentID++, grayBoxX + 110, grayBoxY + 186, 80, 20, "Clear Pending");
        this.field_146292_n.add(this.btnClearPending);
        this.btnBuild = new GuiButtonExt(uiComponentID++, grayBoxX + 195, grayBoxY + 186, 50, 20, GuiLangKeys.translateString("prefab.gui.button.build"));
        this.field_146292_n.add(this.btnBuild);
        this.btnCancel = new GuiButtonExt(uiComponentID++, grayBoxX + 250, grayBoxY + 186, 50, 20, "Close");
        this.field_146292_n.add(this.btnCancel);
        this.tabGeneral = new GuiTab(this.Tabs, GuiLangKeys.translateString("prefab.gui.starter.tab.general"), grayBoxX + 5, grayBoxY - 10);
        this.Tabs.AddTab(this.tabGeneral);
        this.tabDesignRoom = new GuiTab(this.Tabs, "Design Room", grayBoxX + 58, grayBoxY - 10);
        this.tabDesignRoom.width = 90;
        this.tabDesignRoom.visible = false;
        this.Tabs.AddTab(this.tabDesignRoom);
        this.tabPendingChanges = new GuiTab(this.Tabs, "Pending Changes", grayBoxX + 151, grayBoxY - 10);
        this.tabPendingChanges.width = 100;
        this.tabPendingChanges.visible = false;
        this.Tabs.AddTab(this.tabPendingChanges);
        try {
            this.func_146284_a((GuiButton)this.btnGroundFloor);
            this.roomButtons.get((int)45).roomInfo.StructureName = DrafterTileEntityConfig.AvailableRoomType.Foyer;
            this.func_146284_a((GuiButton)this.btnGroundFloor);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return uiComponentID;
    }

    private int createDesignRoomTabControls(int grayBoxX, int grayBoxY, int uiComponentID) {
        this.btnAddToPending = new GuiButtonExt(uiComponentID++, grayBoxX + 115, grayBoxY + 186, 130, 20, "Add To Pending Changes");
        this.field_146292_n.add(this.btnAddToPending);
        this.listRooms = new RoomList(this, this.field_146297_k, 100, 85, grayBoxY + 25, grayBoxX + 10, 20);
        this.roomMaterials = new RoomMaterials(this, this.field_146297_k, 175, 85, grayBoxY + 25, grayBoxX + 125, 20);
        return uiComponentID;
    }

    private int createPendingChangesTabControls(int grayBoxX, int grayBoxY, int uiComponentID) {
        return uiComponentID;
    }

    private void makeGeneralTabControlsVisible() {
        for (GuiRoomInfoButton roomInfoButton : this.roomButtons) {
            roomInfoButton.field_146125_m = true;
        }
        this.btnBasement2.field_146125_m = true;
        this.btnBasement1.field_146125_m = true;
        this.btnBuild.field_146125_m = true;
        this.btnClearPending.field_146125_m = true;
        this.btnGroundFloor.field_146125_m = true;
        this.btnSecondFloor.field_146125_m = true;
        this.btnThirdFloor.field_146125_m = true;
    }

    private void makeDesignRoomTabControlsVisible(int mouseX, int mouseY, float renderPartialTicks) {
        this.btnAddToPending.field_146125_m = true;
        this.listRooms.drawScreen(mouseX, mouseY, renderPartialTicks);
        this.roomMaterials.drawScreen(mouseX, mouseY, renderPartialTicks);
    }

    private void makePendingChangesTabControlsVisible(int mouseX, int mouseY, float renderPartialTicks) {
    }

    private void sendConfigToServer() {
    }

    public class RoomMaterials
    extends GuiScrollingList {
        protected GuiDrafter parent;
        protected int selectdIndex;

        public RoomMaterials(GuiDrafter parent, Minecraft client, int width, int height, int top, int left, int entryHeight) {
            super(client, width, height, top, top + height, left, entryHeight, parent.field_146294_l, parent.field_146295_m);
            this.selectdIndex = 0;
            this.parent = parent;
        }

        protected int getSize() {
            return this.parent.selectedRoomType.getRoomMaterials().size();
        }

        protected void elementClicked(int index, boolean doubleClick) {
            this.selectdIndex = index;
        }

        protected boolean isSelected(int index) {
            return this.selectdIndex == index;
        }

        protected void drawBackground() {
        }

        protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
            FontRenderer font = this.parent.field_146289_q;
            DrafterTileEntityConfig.AvailableRoomType room = DrafterTileEntityConfig.AvailableRoomType.ValueOf(slotIdx);
            ArrayList<DrafterTileEntityConfig.RoomMaterial> selectedRoomMaterials = this.parent.selectedRoomType.getRoomMaterials();
            boolean i = false;
            DrafterTileEntityConfig.RoomMaterial materialForSlot = selectedRoomMaterials.get(slotIdx);
            String itemName = "Not Found!";
            int materialCount = 0;
            ItemStack itemToDraw = null;
            Item foundItem = (Item)Item.field_150901_e.func_82594_a((Object)materialForSlot.resourceLocation);
            if (materialForSlot.metaData >= 0) {
                itemToDraw = new ItemStack(foundItem, 1, materialForSlot.metaData);
                itemName = I18n.func_135052_a((String)(itemToDraw.func_77977_a() + ".name"), (Object[])new Object[0]);
            } else {
                itemName = I18n.func_135052_a((String)(foundItem.func_77658_a() + ".name"), (Object[])new Object[0]);
                itemToDraw = new ItemStack(foundItem);
            }
            materialCount = materialForSlot.numberRequired;
            int foundMaterialCount = this.getFoundMaterialCount(itemToDraw);
            int left = this.left + 3;
            font.func_78276_b(font.func_78269_a(materialCount + "", this.listWidth - 5), left, slotTop + 2, 0xFFFFFF);
            if (foundMaterialCount < materialCount) {
                left += 10;
                if (materialCount > 9) {
                    left += 10;
                }
                font.func_78276_b("(" + foundMaterialCount + ")", left, slotTop + 2, Color.RED.getRGB());
            }
            this.drawItem(left + 16, slotTop - 1, itemToDraw);
            font.func_78276_b(font.func_78269_a(itemName, this.listWidth - 5), left + 40, slotTop + 2, 0xFFFFFF);
        }

        private void drawItem(int x, int z, ItemStack itemToDraw) {
            this.drawItemBackground(x, z, 0, 0);
            GlStateManager.func_179091_B();
            if (itemToDraw != null && itemToDraw.func_77973_b() != null) {
                RenderHelper.func_74520_c();
                this.parent.field_146296_j.func_175042_a(itemToDraw, x + 1, z + 1);
                RenderHelper.func_74518_a();
            }
            GlStateManager.func_179101_C();
        }

        private void drawItemBackground(int x, int z, int textureX, int textureY) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.parent.field_146297_k.func_110434_K().func_110577_a(Gui.field_110323_l);
            float f = 0.0078125f;
            float f1 = 0.0078125f;
            int i = 18;
            int j = 18;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexbuffer = tessellator.func_178180_c();
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vertexbuffer.func_181662_b((double)(x + 0), (double)(z + 18), (double)this.parent.field_73735_i).func_187315_a((double)((float)(textureX + 0) * 0.0078125f), (double)((float)(textureY + 18) * 0.0078125f)).func_181675_d();
            vertexbuffer.func_181662_b((double)(x + 18), (double)(z + 18), (double)this.parent.field_73735_i).func_187315_a((double)((float)(textureX + 18) * 0.0078125f), (double)((float)(textureY + 18) * 0.0078125f)).func_181675_d();
            vertexbuffer.func_181662_b((double)(x + 18), (double)(z + 0), (double)this.parent.field_73735_i).func_187315_a((double)((float)(textureX + 18) * 0.0078125f), (double)((float)(textureY + 0) * 0.0078125f)).func_181675_d();
            vertexbuffer.func_181662_b((double)(x + 0), (double)(z + 0), (double)this.parent.field_73735_i).func_187315_a((double)((float)(textureX + 0) * 0.0078125f), (double)((float)(textureY + 0) * 0.0078125f)).func_181675_d();
            tessellator.func_78381_a();
        }

        private int getFoundMaterialCount(ItemStack desiredItemStack) {
            int returnValue = 0;
            for (ItemStack stack : this.parent.tileEntity.getStacks()) {
                if (stack == null || stack.func_77973_b() != desiredItemStack.func_77973_b() || stack.func_77960_j() != desiredItemStack.func_77960_j()) continue;
                returnValue += stack.func_190916_E();
            }
            return returnValue;
        }
    }

    public class RoomList
    extends GuiScrollingList {
        protected GuiDrafter parent;

        public RoomList(GuiDrafter parent, Minecraft client, int width, int height, int top, int left, int entryHeight) {
            super(client, width, height, top, top + height, left, entryHeight, parent.field_146294_l, parent.field_146295_m);
            this.parent = parent;
        }

        protected int getSize() {
            return DrafterTileEntityConfig.AvailableRoomType.getValues().size();
        }

        protected void elementClicked(int index, boolean doubleClick) {
            DrafterTileEntityConfig.AvailableRoomType roomType;
            this.parent.selectedRoomType = roomType = DrafterTileEntityConfig.AvailableRoomType.ValueOf(index);
        }

        protected boolean isSelected(int index) {
            return this.parent.selectedRoomType.getKey() == index;
        }

        protected void drawBackground() {
        }

        protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
            FontRenderer font = this.parent.field_146289_q;
            DrafterTileEntityConfig.AvailableRoomType room = DrafterTileEntityConfig.AvailableRoomType.ValueOf(slotIdx);
            font.func_78276_b(font.func_78269_a(room.getName(), this.listWidth - 5), this.left + 3, slotTop + 2, 0xFFFFFF);
        }
    }
}

