/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Events;

import com.google.common.collect.ImmutableList;
import com.wuest.prefab.Blocks.BlockCompressedStone;
import com.wuest.prefab.Config.ModConfiguration;
import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.Proxy.ClientProxy;
import com.wuest.prefab.Proxy.CommonProxy;
import com.wuest.prefab.Proxy.Messages.ConfigSyncMessage;
import com.wuest.prefab.Structures.Capabilities.StructureConfigurationCapability;
import com.wuest.prefab.Structures.Capabilities.StructureConfigurationProvider;
import com.wuest.prefab.Structures.Items.ItemBasicStructure;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(value={Side.SERVER, Side.CLIENT})
public class ModEventHandler {
    public static ArrayList<BlockPos> RedstoneAffectedBlockPositions = new ArrayList();

    @SubscribeEvent
    public static void AttachItemStackCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        if (((ItemStack)event.getObject()).func_77973_b() instanceof ItemBasicStructure) {
            event.addCapability(new ResourceLocation("prefab", "structuresconfiguration"), (ICapabilityProvider)new StructureConfigurationProvider(new StructureConfigurationCapability()));
        }
    }

    @SubscribeEvent
    public static void onPlayerLoginEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            NBTTagCompound tag = CommonProxy.proxyConfiguration.ToNBTTagCompound();
            Prefab.network.sendTo((IMessage)new ConfigSyncMessage(tag), (EntityPlayerMP)event.player);
            System.out.println("Sent config to '" + event.player.getDisplayNameString() + "'.");
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.player.field_70170_p.field_72995_K) {
            ((ClientProxy)Prefab.proxy).serverConfiguration = null;
        }
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent onConfigChangedEvent) {
        if (onConfigChangedEvent.getModID().equals("prefab")) {
            ModConfiguration.syncConfig();
        }
    }

    @SubscribeEvent
    public static void AnvilUpdate(AnvilUpdateEvent event) {
        ItemStack rightItem = event.getRight();
        ItemStack leftItem = event.getLeft();
        if ((rightItem.func_77973_b() == Item.func_150898_a((Block)ModRegistry.CompressedStoneBlock()) && rightItem.func_77960_j() == BlockCompressedStone.EnumType.TRIPLE_COMPRESSED_STONE.getMetadata() || leftItem.func_77973_b() == Item.func_150898_a((Block)ModRegistry.CompressedStoneBlock()) && leftItem.func_77960_j() == BlockCompressedStone.EnumType.TRIPLE_COMPRESSED_STONE.getMetadata()) && (rightItem.func_77973_b() == ModRegistry.Bulldozer() || leftItem.func_77973_b() == ModRegistry.Bulldozer())) {
            event.setCost(4);
            ItemStack bulldozer = rightItem.func_77973_b() == ModRegistry.Bulldozer() ? rightItem : leftItem;
            ItemStack outputStack = new ItemStack((Item)ModRegistry.Bulldozer());
            ModRegistry.Bulldozer().setPoweredValue(outputStack, true);
            outputStack.func_77964_b(0);
            event.setOutput(outputStack);
        }
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModRegistry.ModBlocks.toArray(new Block[ModRegistry.ModBlocks.size()]));
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModRegistry.ModItems.toArray(new Item[ModRegistry.ModItems.size()]));
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        ModRegistry.RegisterOreDictionaryRecords();
    }

    @SubscribeEvent
    public static void OnMissingBlockMapping(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping entry : event.getMappings()) {
            BlockCompressedStone mappedBlock = null;
            switch (entry.key.func_110623_a()) {
                case "blockcompressedstone": 
                case "blockCompressedStone": {
                    mappedBlock = ModRegistry.CompressedStoneBlock();
                }
            }
            if (mappedBlock == null) continue;
            entry.remap((IForgeRegistryEntry)mappedBlock);
        }
    }

    @SubscribeEvent
    public static void OnMissingMapping(RegistryEvent.MissingMappings<Item> event) {
        ImmutableList missingMappings = event.getMappings();
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings()) {
            Item mappedItem = null;
            switch (mapping.key.func_110623_a()) {
                case "blockcompressedstone": 
                case "blockCompressedStone": {
                    mappedItem = ModRegistry.ModItems.stream().filter(item -> item.getRegistryName().func_110623_a().equals("block_compressed_stone")).findFirst().get();
                    break;
                }
                case "itemproducefarm": 
                case "itemProduceFarm": {
                    mappedItem = ModRegistry.ProduceFarm();
                    break;
                }
                case "itempileofbricks": 
                case "itemPileOfBricks": {
                    mappedItem = ModRegistry.PileOfBricks();
                    break;
                }
                case "itemhorsestable": 
                case "itemHorseStable": {
                    mappedItem = ModRegistry.HorseStable();
                    break;
                }
                case "itemnethergate": 
                case "itemNetherGate": {
                    mappedItem = ModRegistry.NetherGate();
                    break;
                }
                case "itemwarehouseupgrade": 
                case "itemWareHouseUpgrade": {
                    mappedItem = ModRegistry.WareHouseUpgrade();
                    break;
                }
                case "itemchickencoop": 
                case "itemChickenCoop": {
                    mappedItem = ModRegistry.ChickenCoop();
                    break;
                }
                case "itemtreefarm": 
                case "itemTreeFarm": {
                    mappedItem = ModRegistry.TreeFarm();
                    break;
                }
                case "itemcompressedchest": 
                case "itemCompressedChest": {
                    mappedItem = ModRegistry.CompressedChestItem();
                    break;
                }
                case "itembundleoftimber": 
                case "itemBundleOfTimber": {
                    mappedItem = ModRegistry.BundleOfTimber();
                    break;
                }
                case "itemwarehouse": 
                case "itemWareHouse": {
                    mappedItem = ModRegistry.WareHouse();
                    break;
                }
                case "itempalletofbricks": 
                case "itemPalletOfBricks": {
                    mappedItem = ModRegistry.PalletOfBricks();
                    break;
                }
                case "itemfishpond": 
                case "itemFishPond": {
                    mappedItem = ModRegistry.FishPond();
                    break;
                }
                case "itemmonstermasher": 
                case "itemMonsterMasher": {
                    mappedItem = ModRegistry.MonsterMasher();
                    break;
                }
                case "itemstarthouse": 
                case "itemStartHouse": {
                    mappedItem = ModRegistry.StartHouse();
                    break;
                }
                case "itemadvancedwarehouse": 
                case "itemAdvancedWareHouse": {
                    mappedItem = ModRegistry.AdvancedWareHouse();
                }
            }
            if (mappedItem == null) continue;
            mapping.remap((IForgeRegistryEntry)mappedItem);
        }
    }

    static {
        RedstoneAffectedBlockPositions = new ArrayList();
    }
}

