/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Config;

import com.wuest.prefab.Base.BaseConfig;
import com.wuest.prefab.Blocks.BlockCompressedStone;
import com.wuest.prefab.ModRegistry;
import java.util.AbstractMap;
import java.util.ArrayList;
import net.minecraft.init.Items;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class DrafterTileEntityConfig
extends BaseConfig {
    public RoomInfo[] Basement2FloorRooms;
    public RoomInfo[] BasementFloorRooms;
    public RoomInfo[] FirstFloorRooms;
    public RoomInfo[] SecondFloorRooms;
    public RoomInfo[] ThirdFloorRooms;
    public ArrayList<AbstractMap.SimpleEntry<RoomInfo, AvailableRoomType>> PendingChanges;
    public BlockPos pos;

    static void InitializeMaterials() {
        AvailableRoomType.Field.getRoomMaterials().add(new RoomMaterial(ModRegistry.CompressedStoneBlock().getRegistryName(), BlockCompressedStone.EnumType.COMPRESSED_DIRT.getMetadata(), 4));
        AvailableRoomType.FarmLand.getRoomMaterials().add(new RoomMaterial(ModRegistry.CompressedStoneBlock().getRegistryName(), BlockCompressedStone.EnumType.COMPRESSED_DIRT.getMetadata(), 4));
        AvailableRoomType.FarmLand.getRoomMaterials().add(new RoomMaterial(Items.field_151131_as.getRegistryName(), -1, 3));
        AvailableRoomType.PlainStoneRoom.getRoomMaterials().add(new RoomMaterial(ModRegistry.CompressedStoneBlock().getRegistryName(), BlockCompressedStone.EnumType.COMPRESSED_STONE.getMetadata(), 12));
        AvailableRoomType.TreeFarm.getRoomMaterials().add(new RoomMaterial(ModRegistry.CompressedStoneBlock().getRegistryName(), BlockCompressedStone.EnumType.COMPRESSED_DIRT.getMetadata(), 4));
        AvailableRoomType.TreeFarm.getRoomMaterials().add(new RoomMaterial(Items.field_151131_as.getRegistryName(), -1, 3));
        AvailableRoomType.TreeFarm.getRoomMaterials().add(new RoomMaterial(ModRegistry.BundleOfTimber().getRegistryName(), -1, 2));
    }

    public DrafterTileEntityConfig() {
        this.Initialize();
    }

    @Override
    public void WriteToNBTCompound(NBTTagCompound compound) {
        NBTTagCompound drafter = new NBTTagCompound();
        NBTTagCompound basementRooms = new NBTTagCompound();
        for (RoomInfo info : this.BasementFloorRooms) {
            if (info == null) continue;
            info.WriteToNBTTagCompound(basementRooms);
        }
        drafter.func_74782_a("basement_rooms", (NBTBase)basementRooms);
        NBTTagCompound basement2Rooms = new NBTTagCompound();
        for (RoomInfo info : this.Basement2FloorRooms) {
            if (info == null) continue;
            info.WriteToNBTTagCompound(basement2Rooms);
        }
        drafter.func_74782_a("basement2_rooms", (NBTBase)basement2Rooms);
        NBTTagCompound firstFloorRooms = new NBTTagCompound();
        for (RoomInfo info : this.FirstFloorRooms) {
            if (info == null) continue;
            info.WriteToNBTTagCompound(firstFloorRooms);
        }
        drafter.func_74782_a("first_rooms", (NBTBase)firstFloorRooms);
        NBTTagCompound secondFloorRooms = new NBTTagCompound();
        for (RoomInfo info : this.SecondFloorRooms) {
            if (info == null) continue;
            info.WriteToNBTTagCompound(secondFloorRooms);
        }
        drafter.func_74782_a("second_rooms", (NBTBase)secondFloorRooms);
        NBTTagCompound thirdFloorRooms = new NBTTagCompound();
        for (RoomInfo info : this.ThirdFloorRooms) {
            if (info == null) continue;
            info.WriteToNBTTagCompound(thirdFloorRooms);
        }
        drafter.func_74782_a("third_rooms", (NBTBase)thirdFloorRooms);
        if (this.pos != null) {
            drafter.func_74768_a("x", this.pos.func_177958_n());
            drafter.func_74768_a("y", this.pos.func_177956_o());
            drafter.func_74768_a("z", this.pos.func_177952_p());
        }
        if (this.PendingChanges.size() > 0) {
            NBTTagCompound pendingChanges = new NBTTagCompound();
            for (AbstractMap.SimpleEntry<RoomInfo, AvailableRoomType> entry : this.PendingChanges) {
                NBTTagCompound pendingChange = new NBTTagCompound();
                entry.getKey().WriteToNBTTagCompound(pendingChange);
                pendingChange.func_74778_a("availableRoomType", entry.getValue().getName());
                pendingChanges.func_74782_a(Integer.valueOf(entry.getKey().ID).toString(), (NBTBase)pendingChange);
            }
            compound.func_74782_a("pendingChanges", (NBTBase)pendingChanges);
        }
        compound.func_74782_a("drafter", (NBTBase)drafter);
    }

    public DrafterTileEntityConfig ReadFromNBTTagCompound(NBTTagCompound compound) {
        DrafterTileEntityConfig config = new DrafterTileEntityConfig();
        if (compound.func_74764_b("drafter")) {
            NBTTagCompound drafter = compound.func_74775_l("drafter");
            if (drafter.func_74764_b("x")) {
                this.pos = new BlockPos(drafter.func_74762_e("x"), drafter.func_74762_e("y"), drafter.func_74762_e("z"));
            }
            if (drafter.func_74764_b("basement_rooms")) {
                NBTTagCompound basement_rooms = (NBTTagCompound)drafter.func_74781_a("basement_rooms");
                this.createRoomsFromTag(basement_rooms, this.BasementFloorRooms);
            }
            if (drafter.func_74764_b("basement2_rooms")) {
                NBTTagCompound basement2_rooms = (NBTTagCompound)drafter.func_74781_a("basement2_rooms");
                this.createRoomsFromTag(basement2_rooms, this.Basement2FloorRooms);
            }
            if (drafter.func_74764_b("first_rooms")) {
                NBTTagCompound first_rooms = (NBTTagCompound)drafter.func_74781_a("first_rooms");
                this.createRoomsFromTag(first_rooms, this.FirstFloorRooms);
            }
            if (drafter.func_74764_b("second_rooms")) {
                NBTTagCompound second_rooms = (NBTTagCompound)drafter.func_74781_a("second_rooms");
                this.createRoomsFromTag(second_rooms, this.SecondFloorRooms);
            }
            if (drafter.func_74764_b("third_rooms")) {
                NBTTagCompound third_rooms = (NBTTagCompound)drafter.func_74781_a("third_rooms");
                this.createRoomsFromTag(third_rooms, this.ThirdFloorRooms);
            }
            if (drafter.func_74764_b("pendingChanges")) {
                NBTTagCompound pendingChanges = drafter.func_74775_l("pendingChanges");
                for (String key : pendingChanges.func_150296_c()) {
                    NBTTagCompound pendingChange = compound.func_74775_l(key);
                    AvailableRoomType roomType = AvailableRoomType.Empty;
                    RoomInfo roomInfo = null;
                    for (String pendingChangeKey : pendingChange.func_150296_c()) {
                        if (pendingChangeKey.equals("availableRoomType")) {
                            roomType = AvailableRoomType.ValueOf(pendingChange.func_74779_i(pendingChangeKey));
                            continue;
                        }
                        roomInfo = RoomInfo.CreateFromNBTTag(pendingChange.func_74775_l(pendingChangeKey));
                    }
                    if (roomInfo == null || roomType == AvailableRoomType.Empty) continue;
                    this.AddUpdatePendingChange(roomInfo, roomType);
                }
            }
        }
        return config;
    }

    public void Initialize() {
        this.FirstFloorRooms = new RoomInfo[49];
        this.InitializeArray(this.FirstFloorRooms);
        this.BasementFloorRooms = new RoomInfo[49];
        this.InitializeArray(this.BasementFloorRooms);
        this.SecondFloorRooms = new RoomInfo[49];
        this.InitializeArray(this.SecondFloorRooms);
        this.Basement2FloorRooms = new RoomInfo[49];
        this.InitializeArray(this.Basement2FloorRooms);
        this.ThirdFloorRooms = new RoomInfo[49];
        this.InitializeArray(this.ThirdFloorRooms);
        this.PendingChanges = new ArrayList();
    }

    public void AddUpdatePendingChange(RoomInfo roomInfo, AvailableRoomType roomType) {
        boolean updatedEntry = false;
        for (AbstractMap.SimpleEntry<RoomInfo, AvailableRoomType> entry : this.PendingChanges) {
            if (roomInfo.ID != entry.getKey().ID) continue;
            entry.setValue(roomType);
            updatedEntry = true;
            break;
        }
        if (!updatedEntry) {
            this.PendingChanges.add(new AbstractMap.SimpleEntry<RoomInfo, AvailableRoomType>(roomInfo, roomType));
        }
    }

    public void RemovePendingChange(RoomInfo roomInfo) {
        AbstractMap.SimpleEntry<RoomInfo, AvailableRoomType> entryToRemove = null;
        for (AbstractMap.SimpleEntry<RoomInfo, AvailableRoomType> entry : this.PendingChanges) {
            if (roomInfo.ID != entry.getKey().ID) continue;
            entryToRemove = entry;
            break;
        }
        if (entryToRemove != null) {
            this.PendingChanges.remove(entryToRemove);
        }
    }

    protected void createRoomsFromTag(NBTTagCompound compound, RoomInfo[] rooms) {
        for (String key : compound.func_150296_c()) {
            if (!key.startsWith("room")) continue;
            NBTTagCompound roomTag = compound.func_74775_l(key);
            RoomInfo newRoom = RoomInfo.CreateFromNBTTag(roomTag);
            if (newRoom.ID == -1) continue;
            rooms[newRoom.ID] = newRoom;
        }
    }

    protected void InitializeArray(RoomInfo[] roomInfo) {
        for (int i = 0; i < roomInfo.length; ++i) {
            RoomInfo info;
            roomInfo[i] = info = new RoomInfo(i);
        }
    }

    static {
        DrafterTileEntityConfig.InitializeMaterials();
    }

    public static enum AvailableRoomType {
        Empty(-2, "Empty"),
        Foyer(-1, "Foyer"),
        Field(0, "Field"),
        FarmLand(1, "Farm Land"),
        PlainStoneRoom(2, "Plain Stone Room"),
        TreeFarm(3, "Tree Farm");

        private final int key;
        private final String name;
        private ArrayList<RoomMaterial> roomMaterials;

        private AvailableRoomType(int key, String name) {
            this.key = key;
            this.name = name;
            this.roomMaterials = new ArrayList();
        }

        public int getKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }

        public static ArrayList<AvailableRoomType> getValues() {
            ArrayList<AvailableRoomType> roomTypes = new ArrayList<AvailableRoomType>();
            for (AvailableRoomType roomType : AvailableRoomType.values()) {
                if (roomType == Empty || roomType == Foyer) continue;
                roomTypes.add(roomType);
            }
            return roomTypes;
        }

        public ArrayList<RoomMaterial> getRoomMaterials() {
            return this.roomMaterials;
        }

        public static AvailableRoomType ValueOf(int value) {
            for (AvailableRoomType room : AvailableRoomType.values()) {
                if (value != room.getKey()) continue;
                return room;
            }
            return Empty;
        }

        public static AvailableRoomType ValueOf(String roomName) {
            for (AvailableRoomType room : AvailableRoomType.values()) {
                if (!roomName.equals(room.name)) continue;
                return room;
            }
            return Empty;
        }
    }

    public static class RoomMaterial {
        public ResourceLocation resourceLocation;
        public int metaData;
        public int numberRequired;

        public RoomMaterial(ResourceLocation resourceLocation, int metaData, int numberRequried) {
            this.resourceLocation = resourceLocation;
            this.metaData = metaData;
            this.numberRequired = numberRequried;
        }
    }

    public static class RoomInfo {
        public int ID = -1;
        public AvailableRoomType StructureName;
        public EnumFacing StructureFacing;
        public BlockPos RoomCoordinates;
        public boolean PendingBuilding;
        public int FloorNumber;

        public RoomInfo(int id) {
            this.ID = id;
            this.StructureFacing = EnumFacing.NORTH;
            this.RoomCoordinates = new BlockPos(0, 0, 0);
            this.StructureName = AvailableRoomType.Empty;
            this.PendingBuilding = false;
            this.FloorNumber = 0;
        }

        public static RoomInfo CreateFromNBTTag(NBTTagCompound compound) {
            if (compound.func_74764_b("ID")) {
                RoomInfo info = new RoomInfo(compound.func_74762_e("ID"));
                String roomName = compound.func_74779_i("name");
                info.StructureName = AvailableRoomType.ValueOf(compound.func_74779_i("name"));
                info.StructureFacing = EnumFacing.func_176739_a((String)compound.func_74779_i("facing"));
                info.RoomCoordinates = new BlockPos(compound.func_74762_e("x"), compound.func_74762_e("y"), compound.func_74762_e("z"));
                info.PendingBuilding = compound.func_74767_n("pendingBuilding");
                info.FloorNumber = compound.func_74762_e("floor_number");
                return info;
            }
            return null;
        }

        public void WriteToNBTTagCompound(NBTTagCompound compound) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("ID", this.ID);
            tag.func_74778_a("name", this.StructureName.getName());
            tag.func_74778_a("facing", this.StructureFacing.func_176610_l());
            tag.func_74768_a("x", this.RoomCoordinates.func_177958_n());
            tag.func_74768_a("y", this.RoomCoordinates.func_177956_o());
            tag.func_74768_a("z", this.RoomCoordinates.func_177952_p());
            tag.func_74757_a("pendingBuilding", this.PendingBuilding);
            tag.func_74768_a("floor_number", this.FloorNumber);
            compound.func_74782_a("room_" + this.ID, (NBTBase)tag);
        }

        public boolean checkNeighbors(RoomInfo[] roomInfoArray) {
            String emptyRoomName = AvailableRoomType.Empty.getName();
            if (this.StructureName.getName().equals(emptyRoomName)) {
                RoomInfo roomToTheLeft = this.getRoomInfoForID(roomInfoArray, this.ID - 1);
                RoomInfo roomToTheRight = this.getRoomInfoForID(roomInfoArray, this.ID + 1);
                RoomInfo roomAbove = this.getRoomInfoForID(roomInfoArray, this.ID - 7);
                RoomInfo roomBelow = this.getRoomInfoForID(roomInfoArray, this.ID + 7);
                return roomToTheLeft != null && !roomToTheLeft.StructureName.getName().equals(emptyRoomName) || roomToTheRight != null && !roomToTheRight.StructureName.getName().equals(emptyRoomName) || roomAbove != null && !roomAbove.StructureName.getName().equals(emptyRoomName) || roomBelow != null && !roomBelow.StructureName.getName().equals(emptyRoomName);
            }
            return true;
        }

        protected RoomInfo getRoomInfoForID(RoomInfo[] roomInfoArray, int id) {
            if (id < 0 || id >= 49) {
                return null;
            }
            return roomInfoArray[id];
        }
    }
}

