/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.inventory;

import aroma1997.core.container.IGuiProvider;
import aroma1997.core.inventory.IInventoryPartContainer;
import aroma1997.core.inventory.inventorypart.InventoryPartBase;
import aroma1997.core.util.ServerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.ITextComponent;

public abstract class ItemInventory
implements IInventoryPartContainer,
IGuiProvider,
ISidedInventory {
    public Supplier<ItemStack> item;
    private List<InventoryPartBase> parts = new ArrayList<InventoryPartBase>();
    private boolean isReading = false;

    public ItemInventory(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof IGuiProvider.IItemGuiProvider)) {
            throw new IllegalArgumentException();
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        this.item = () -> stack;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
    }

    protected ItemStack getStack() {
        return this.item.get();
    }

    @Override
    public void markDirtyInternal() {
        this.save();
    }

    public final void func_70296_d() {
        for (InventoryPartBase part : this.getParts()) {
            part.markDirtyInternal();
        }
        this.markDirtyInternal();
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.getStack().func_77978_p().func_74779_i("display");
        }
        return this.getDefaultName();
    }

    protected String getDefaultName() {
        return "Item Inventory";
    }

    public boolean func_145818_k_() {
        return this.getStack().func_77978_p().func_74764_b("display");
    }

    public ITextComponent func_145748_c_() {
        return ServerUtil.getChatForString(this.func_70005_c_());
    }

    protected void readFromNBT(NBTTagCompound compound) {
        for (InventoryPartBase part : this.parts) {
            NBTTagCompound current = compound.func_74775_l("inv_" + part.func_70005_c_());
            part.readFromNBT(current);
        }
    }

    protected NBTTagCompound writeToNBT(NBTTagCompound compound) {
        for (InventoryPartBase part : this.parts) {
            NBTTagCompound current = part.writeToNBT(new NBTTagCompound());
            compound.func_74782_a("inv_" + part.func_70005_c_(), (NBTBase)current);
        }
        return compound;
    }

    public void load() {
        this.readFromNBT(this.getStack().func_77978_p());
    }

    private void save() {
        if (this.isReading) {
            return;
        }
        this.isReading = true;
        ItemStack ourStack = this.getStack();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) != ourStack) continue;
            this.func_70299_a(i, ItemStack.field_190927_a);
        }
        this.isReading = false;
        this.writeToNBT(this.getStack().func_77978_p());
    }

    @Override
    public void addInventoryPart(InventoryPartBase part) {
        this.parts.add(part);
    }

    @Override
    public ItemStack func_70298_a(int index, int count) {
        Tuple<InventoryPartBase, Integer> partSlot = this.getPartSlot(index);
        ItemStack ret = ((InventoryPartBase)partSlot.func_76341_a()).func_70298_a((Integer)partSlot.func_76340_b(), count);
        this.save();
        return ret;
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        Tuple<InventoryPartBase, Integer> partSlot = this.getPartSlot(index);
        ((InventoryPartBase)partSlot.func_76341_a()).func_70299_a((Integer)partSlot.func_76340_b(), stack);
        this.save();
    }

    @Override
    public void func_174888_l() {
        this.parts.stream().forEach(IInventory::func_174888_l);
        this.save();
    }

    @Override
    public Collection<InventoryPartBase> getParts() {
        return this.parts;
    }
}

